/*
 * Decompiled with CFR 0.152.
 */
package com.getsentry.raven.config;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JndiLookup {
    private static final String JNDI_PREFIX = "java:comp/env/sentry/";
    private static final Logger logger = LoggerFactory.getLogger(JndiLookup.class);

    private JndiLookup() {
    }

    public static String jndiLookup(String key) {
        String value = null;
        try {
            InitialContext c = new InitialContext();
            value = (String)c.lookup(JNDI_PREFIX + key);
        }
        catch (NoInitialContextException e) {
            logger.debug("JNDI not configured for Sentry (NoInitialContextEx)");
        }
        catch (NamingException e) {
            logger.debug("No /sentry/" + key + " in JNDI");
        }
        catch (RuntimeException e) {
            logger.warn("Odd RuntimeException while testing for JNDI", e);
        }
        return value;
    }
}

