/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.spark.bigquery;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.hadoop.io.bigquery.BigQueryStrings;
import com.google.cloud.hadoop.io.bigquery.BigQueryUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.spotify.spark.bigquery.BigQueryClient$;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Progressable;
import org.joda.time.Instant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t-rAB\u0001\u0003\u0011\u0003\u0011!\"\u0001\bCS\u001e\fV/\u001a:z\u00072LWM\u001c;\u000b\u0005\r!\u0011\u0001\u00032jOF,XM]=\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u001d\u0019\bo\u001c;jMfT\u0011!C\u0001\u0004G>l\u0007CA\u0006\r\u001b\u0005\u0011aAB\u0007\u0003\u0011\u0003\u0011aB\u0001\bCS\u001e\fV/\u001a:z\u00072LWM\u001c;\u0014\u00051y\u0001C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\rC\u0003\u0017\u0019\u0011\u0005\u0001$\u0001\u0004=S:LGOP\u0002\u0001)\u0005Q\u0001b\u0002\u000e\r\u0005\u0004%\taG\u0001\u0017'R\u000bu)\u0013(H?\u0012\u000bE+Q*F)~\u0003&+\u0012$J1V\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005!A.\u00198h\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u0010\u0003\rM#(/\u001b8h\u0011\u0019)C\u0002)A\u00059\u000592\u000bV!H\u0013:;u\fR!U\u0003N+Ek\u0018)S\u000b\u001aK\u0005\f\t\u0005\bO1\u0011\r\u0011\"\u0001\u001c\u0003y\u0019F+Q$J\u001d\u001e{F)\u0011+B'\u0016#v\f\u0015*F\r&Cv\fR#G\u0003VcE\u000b\u0003\u0004*\u0019\u0001\u0006I\u0001H\u0001 'R\u000bu)\u0013(H?\u0012\u000bE+Q*F)~\u0003&+\u0012$J1~#UIR!V\u0019R\u0003\u0003bB\u0016\r\u0005\u0004%\taG\u0001\u0019'R\u000bu)\u0013(H?\u0012\u000bE+Q*F)~cujQ!U\u0013>s\u0005BB\u0017\rA\u0003%A$A\rT)\u0006;\u0015JT$`\t\u0006#\u0016iU#U?2{5)\u0011+J\u001f:\u0003\u0003bB\u0018\r\u0005\u0004%\taG\u0001!'R\u000bu)\u0013(H?\u0012\u000bE+Q*F)~cujQ!U\u0013>su\fR#G\u0003VcE\u000b\u0003\u00042\u0019\u0001\u0006I\u0001H\u0001\"'R\u000bu)\u0013(H?\u0012\u000bE+Q*F)~cujQ!U\u0013>su\fR#G\u0003VcE\u000b\t\u0005\bg1\u0011\r\u0011\"\u00015\u0003\r\u001aF+Q$J\u001d\u001e{F)\u0011+B'\u0016#v\fV!C\u0019\u0016{V\t\u0017)J%\u0006#\u0016j\u0014(`\u001bN+\u0012!\u000e\t\u0003!YJ!aN\t\u0003\t1{gn\u001a\u0005\u0007s1\u0001\u000b\u0011B\u001b\u0002IM#\u0016iR%O\u000f~#\u0015\tV!T\u000bR{F+\u0011\"M\u000b~+\u0005\fU%S\u0003RKuJT0N'\u0002Bqa\u000f\u0007C\u0002\u0013\u00051$A\u000eT)\u0006;\u0015JT$`\t\u0006#\u0016iU#U?\u0012+5k\u0011*J!RKuJ\u0014\u0005\u0007{1\u0001\u000b\u0011\u0002\u000f\u00029M#\u0016iR%O\u000f~#\u0015\tV!T\u000bR{F)R*D%&\u0003F+S(OA!9q\b\u0004a\u0001\n\u0013\u0001\u0015\u0001C5ogR\fgnY3\u0016\u0003\u0005\u0003\"a\u0003\"\u0007\u000b5\u0011\u0001AA\"\u0014\u0005\t{\u0001\u0002C#C\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\t\r|gN\u001a\t\u0003\u000f>k\u0011\u0001\u0013\u0006\u0003\u000b&S!AS&\u0002\r!\fGm\\8q\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003\u0017\u0005\u0012\u0005!\u000b\u0006\u0002B'\")Q)\u0015a\u0001\r\"9QK\u0011b\u0001\n\u00131\u0016A\u00027pO\u001e,'/F\u0001X!\tA6,D\u0001Z\u0015\tQV*A\u0003tY\u001a$$.\u0003\u0002]3\n1Aj\\4hKJDaA\u0018\"!\u0002\u00139\u0016a\u00027pO\u001e,'\u000f\t\u0005\bA\n\u0013\r\u0011\"\u0003b\u0003\u0019\u00196i\u0014)F'V\t!\rE\u0002dMri\u0011\u0001\u001a\u0006\u0003K\u0002\nA!\u001e;jY&\u0011q\r\u001a\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004j\u0005\u0002\u0006IAY\u0001\b'\u000e{\u0005+R*!\u0011\u001d\u0019!I1A\u0005\n-,\u0012\u0001\u001c\t\u0003[Vl\u0011A\u001c\u0006\u0003\u0007=T!\u0001]9\u0002\u0011M,'O^5dKNT!A]:\u0002\u0007\u0005\u0004\u0018N\u0003\u0002u\u0011\u00051qm\\8hY\u0016L!A\u001e8\u0003\u0011\tKw-];fefDa\u0001\u001f\"!\u0002\u0013a\u0017!\u00032jOF,XM]=!\u0011\u0015Q(\t\"\u0003|\u0003%\u0001(o\u001c6fGRLE-F\u0001}!\ri\u0018\u0011\u0001\b\u0003!yL!a`\t\u0002\rA\u0013X\rZ3g\u0013\r\u0019\u00131\u0001\u0006\u0003\u007fFA\u0011\"a\u0002C\u0005\u0004%I!!\u0003\u0002\u0015E,XM]=DC\u000eDW-\u0006\u0002\u0002\fA9\u0011QBA\fy\u0006mQBAA\b\u0015\u0011\t\t\"a\u0005\u0002\u000b\r\f7\r[3\u000b\u0007\u0005U1/\u0001\u0004d_6lwN\\\u0005\u0005\u00033\tyA\u0001\u0007M_\u0006$\u0017N\\4DC\u000eDW\r\u0005\u0003\u0002\u001e\u0005\rRBAA\u0010\u0015\r\t\tC\\\u0001\u0006[>$W\r\\\u0005\u0005\u0003K\tyB\u0001\bUC\ndWMU3gKJ,gnY3\t\u0011\u0005%\"\t)A\u0005\u0003\u0017\t1\"];fef\u001c\u0015m\u00195fA!9\u0011Q\u0006\"\u0005\n\u0005=\u0012!C5o\u0007>t7o\u001c7f+\t\t\t\u0004E\u0002\u0011\u0003gI1!!\u000e\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u000fC\u0005\u0004%IaG\u0001\t!JKuJU%U3\"9\u0011Q\b\"!\u0002\u0013a\u0012!\u0003)S\u0013>\u0013\u0016\nV-!\u0011!\t\tE\u0011b\u0001\n\u0013Y\u0012a\u0004+B\u00052+u,\u0013#`!J+e)\u0013-\t\u000f\u0005\u0015#\t)A\u00059\u0005\u0001B+\u0011\"M\u000b~KEi\u0018)S\u000b\u001aK\u0005\f\t\u0005\t\u0003\u0013\u0012%\u0019!C\u00057\u0005i!j\u0014\"`\u0013\u0012{\u0006KU#G\u0013bCq!!\u0014CA\u0003%A$\u0001\bK\u001f\n{\u0016\nR0Q%\u00163\u0015\n\u0017\u0011\t\u0013\u0005E#I1A\u0005\n\u0005M\u0013A\u0004+J\u001b\u0016{fi\u0014*N\u0003R#VIU\u000b\u0003\u0003+\u0002B!a\u0016\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0005\u0003?\n\t'\u0001\u0003uS6,'bAA2\u001b\u0006!!n\u001c3b\u0013\u0011\t9'!\u0017\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f\u0003\u0005\u0002l\t\u0003\u000b\u0011BA+\u0003=!\u0016*T#`\r>\u0013V*\u0011+U\u000bJ\u0003\u0003bBA8\u0005\u0012\u0005\u0011\u0011O\u0001\u0006cV,'/\u001f\u000b\u0005\u00037\t\u0019\bC\u0004\u0002v\u00055\u0004\u0019\u0001?\u0002\u0011M\fH.U;fefDq!!\u001fC\t\u0003\tY(\u0001\u0003m_\u0006$GCCA?\u0003\u0007\u000b9)a#\u0002 B\u0019\u0001#a \n\u0007\u0005\u0005\u0015C\u0001\u0003V]&$\bbBAC\u0003o\u0002\r\u0001`\u0001\bO\u000e\u001c\b+\u0019;i\u0011!\tI)a\u001eA\u0002\u0005m\u0011\u0001\u00053fgRLg.\u0019;j_:$\u0016M\u00197f\u0011)\ti)a\u001e\u0011\u0002\u0003\u0007\u0011qR\u0001\u0011oJLG/\u001a#jgB|7/\u001b;j_:\u0004B!!%\u0002\u0018:\u00191\"a%\n\u0007\u0005U%!\u0001\tXe&$X\rR5ta>\u001c\u0018\u000e^5p]&!\u0011\u0011TAN\u0005\u00151\u0016\r\\;f\u0013\r\ti*\u0005\u0002\f\u000b:,X.\u001a:bi&|g\u000e\u0003\u0006\u0002\"\u0006]\u0004\u0013!a\u0001\u0003G\u000b\u0011c\u0019:fCR,G)[:q_NLG/[8o!\u0011\t)+a&\u000f\u0007-\t9+C\u0002\u0002*\n\t\u0011c\u0011:fCR,G)[:q_NLG/[8o\u0011\u001d\tiK\u0011C\u0005\u0003_\u000b!b^1ji\u001a{'OS8c)\u0011\ti(!-\t\u0011\u0005M\u00161\u0016a\u0001\u0003k\u000b1A[8c!\u0011\ti\"a.\n\t\u0005e\u0016q\u0004\u0002\u0004\u0015>\u0014\u0007bBA_\u0005\u0012%\u0011qX\u0001\u000fgR\fw-\u001b8h\t\u0006$\u0018m]3u)\u0011\t\t-a2\u0011\t\u0005u\u00111Y\u0005\u0005\u0003\u000b\fyB\u0001\tECR\f7/\u001a;SK\u001a,'/\u001a8dK\"9\u0011\u0011ZA^\u0001\u0004a\u0018\u0001\u00037pG\u0006$\u0018n\u001c8\t\u000f\u00055'\t\"\u0003\u0002P\u0006qA/Z7q_J\f'/\u001f+bE2,G\u0003BA\u000e\u0003#Dq!!3\u0002L\u0002\u0007A\u0010C\u0004\u0002V\n#I!a6\u0002\u001d\r\u0014X-\u0019;f#V,'/\u001f&pERA\u0011QWAm\u00037\fi\u000eC\u0004\u0002v\u0005M\u0007\u0019\u0001?\t\u0011\u0005%\u00151\u001ba\u0001\u00037A\u0001\"a8\u0002T\u0002\u0007\u0011\u0011G\u0001\u0007IJL(+\u001e8\t\u000f\u0005\r(\t\"\u0003\u0002f\u0006\u00112M]3bi\u0016TuN\u0019*fM\u0016\u0014XM\\2f)\u0019\t9/!<\u0002pB!\u0011QDAu\u0013\u0011\tY/a\b\u0003\u0019){'MU3gKJ,gnY3\t\ri\f\t\u000f1\u0001}\u0011\u001d\t\t0!9A\u0002q\f1B[8c\u0013\u0012\u0004&/\u001a4jq\"I\u0011Q\u001f\"\u0012\u0002\u0013\u0005\u0011q_\u0001\u000fY>\fG\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tIP\u000b\u0003\u0002\u0010\u0006m8FAA\u007f!\u0011\tyP!\u0003\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001d\u0011#\u0001\u0006b]:|G/\u0019;j_:LAAa\u0003\u0003\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t=!)%A\u0005\u0002\tE\u0011A\u00047pC\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005'QC!a)\u0002|\"I!q\u0003\u0007A\u0002\u0013%!\u0011D\u0001\rS:\u001cH/\u00198dK~#S-\u001d\u000b\u0005\u0003{\u0012Y\u0002C\u0005\u0003\u001e\tU\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\t\u000f\t\u0005B\u0002)Q\u0005\u0003\u0006I\u0011N\\:uC:\u001cW\r\t\u0005\b\u0005KaA\u0011\u0001B\u0014\u0003-9W\r^%ogR\fgnY3\u0015\u0007\u0005\u0013I\u0003\u0003\u0004F\u0005G\u0001\rA\u0012")
public class BigQueryClient {
    public final Configuration com$spotify$spark$bigquery$BigQueryClient$$conf;
    private final Logger com$spotify$spark$bigquery$BigQueryClient$$logger;
    private final List<String> SCOPES;
    private final Bigquery bigquery;
    private final LoadingCache<String, TableReference> queryCache;
    private final String PRIORITY;
    private final String TABLE_ID_PREFIX;
    private final String JOB_ID_PREFIX;
    private final DateTimeFormatter TIME_FORMATTER;

    public static BigQueryClient getInstance(Configuration configuration) {
        return BigQueryClient$.MODULE$.getInstance(configuration);
    }

    public static String STAGING_DATASET_DESCRIPTION() {
        return BigQueryClient$.MODULE$.STAGING_DATASET_DESCRIPTION();
    }

    public static long STAGING_DATASET_TABLE_EXPIRATION_MS() {
        return BigQueryClient$.MODULE$.STAGING_DATASET_TABLE_EXPIRATION_MS();
    }

    public static String STAGING_DATASET_LOCATION_DEFAULT() {
        return BigQueryClient$.MODULE$.STAGING_DATASET_LOCATION_DEFAULT();
    }

    public static String STAGING_DATASET_LOCATION() {
        return BigQueryClient$.MODULE$.STAGING_DATASET_LOCATION();
    }

    public static String STAGING_DATASET_PREFIX_DEFAULT() {
        return BigQueryClient$.MODULE$.STAGING_DATASET_PREFIX_DEFAULT();
    }

    public static String STAGING_DATASET_PREFIX() {
        return BigQueryClient$.MODULE$.STAGING_DATASET_PREFIX();
    }

    public Logger com$spotify$spark$bigquery$BigQueryClient$$logger() {
        return this.com$spotify$spark$bigquery$BigQueryClient$$logger;
    }

    private List<String> SCOPES() {
        return this.SCOPES;
    }

    private Bigquery bigquery() {
        return this.bigquery;
    }

    private String projectId() {
        return this.com$spotify$spark$bigquery$BigQueryClient$$conf.get("mapred.bq.project.id");
    }

    private LoadingCache<String, TableReference> queryCache() {
        return this.queryCache;
    }

    private boolean inConsole() {
        return Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StackTraceElement x$1) {
                return x$1.getClassName().startsWith("scala.tools.nsc.interpreter.");
            }
        });
    }

    private String PRIORITY() {
        return this.PRIORITY;
    }

    private String TABLE_ID_PREFIX() {
        return this.TABLE_ID_PREFIX;
    }

    private String JOB_ID_PREFIX() {
        return this.JOB_ID_PREFIX;
    }

    private DateTimeFormatter TIME_FORMATTER() {
        return this.TIME_FORMATTER;
    }

    public TableReference query(String sqlQuery) {
        return (TableReference)this.queryCache().get((Object)sqlQuery);
    }

    public void load(String gcsPath, TableReference destinationTable, Enumeration.Value writeDisposition, Enumeration.Value createDisposition) {
        String tableName = BigQueryStrings.toString((TableReference)destinationTable);
        this.com$spotify$spark$bigquery$BigQueryClient$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading ", " into ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gcsPath, tableName})));
        JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(destinationTable).setSourceFormat("AVRO").setSourceUris((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)gcsPath).append((Object)"/*.avro").toString()}))).asJava());
        if (writeDisposition != null) {
            loadConfig = loadConfig.setWriteDisposition(writeDisposition.toString());
        }
        if (createDisposition != null) {
            loadConfig = loadConfig.setCreateDisposition(createDisposition.toString());
        }
        JobConfiguration jobConfig = new JobConfiguration().setLoad(loadConfig);
        JobReference jobReference = this.createJobReference(this.projectId(), this.JOB_ID_PREFIX());
        Job job = new Job().setConfiguration(jobConfig).setJobReference(jobReference);
        this.bigquery().jobs().insert(this.projectId(), job).execute();
        this.com$spotify$spark$bigquery$BigQueryClient$$waitForJob(job);
    }

    public Enumeration.Value load$default$3() {
        return null;
    }

    public Enumeration.Value load$default$4() {
        return null;
    }

    public void com$spotify$spark$bigquery$BigQueryClient$$waitForJob(Job job) {
        BigQueryUtils.waitForJobCompletion((Bigquery)this.bigquery(), (String)this.projectId(), (JobReference)job.getJobReference(), (Progressable)new Progressable(this){

            public void progress() {
            }
        });
    }

    private DatasetReference stagingDataset(String location) {
        Throwable throwable;
        Throwable throwable22;
        block3: {
            Object object;
            String prefix = this.com$spotify$spark$bigquery$BigQueryClient$$conf.get(BigQueryClient$.MODULE$.STAGING_DATASET_PREFIX(), BigQueryClient$.MODULE$.STAGING_DATASET_PREFIX_DEFAULT());
            String datasetId = new StringBuilder().append((Object)prefix).append((Object)location.toLowerCase()).toString();
            try {
                this.bigquery().datasets().get(this.projectId(), datasetId).execute();
                this.com$spotify$spark$bigquery$BigQueryClient$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Staging dataset ", ":", " already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectId(), datasetId})));
                object = BoxedUnit.UNIT;
            }
            catch (Throwable throwable22) {
                GoogleJsonResponseException googleJsonResponseException;
                throwable = throwable22;
                if (!(throwable instanceof GoogleJsonResponseException) || (googleJsonResponseException = (GoogleJsonResponseException)throwable).getStatusCode() != 404) break block3;
                this.com$spotify$spark$bigquery$BigQueryClient$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating staging dataset ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.projectId(), datasetId})));
                DatasetReference dsRef = new DatasetReference().setProjectId(this.projectId()).setDatasetId(datasetId);
                Dataset ds = new Dataset().setDatasetReference(dsRef).setDefaultTableExpirationMs(Predef$.MODULE$.long2Long(BigQueryClient$.MODULE$.STAGING_DATASET_TABLE_EXPIRATION_MS())).setDescription(BigQueryClient$.MODULE$.STAGING_DATASET_DESCRIPTION()).setLocation(location);
                Object object2 = this.bigquery().datasets().insert(this.projectId(), ds).execute();
                object = object2;
            }
            return new DatasetReference().setProjectId(this.projectId()).setDatasetId(datasetId);
        }
        Option option = NonFatal$.MODULE$.unapply(throwable);
        if (option.isEmpty()) {
            throw throwable22;
        }
        Throwable e = (Throwable)option.get();
        throw e;
    }

    public TableReference com$spotify$spark$bigquery$BigQueryClient$$temporaryTable(String location) {
        String now = Instant.now().toString(this.TIME_FORMATTER());
        String tableId = new StringBuilder().append((Object)this.TABLE_ID_PREFIX()).append((Object)"_").append((Object)now).append((Object)"_").append((Object)BoxesRunTime.boxToInteger((int)Random$.MODULE$.nextInt(Integer.MAX_VALUE))).toString();
        return new TableReference().setProjectId(this.projectId()).setDatasetId(this.stagingDataset(location).getDatasetId()).setTableId(tableId);
    }

    public Job com$spotify$spark$bigquery$BigQueryClient$$createQueryJob(String sqlQuery, TableReference destinationTable, boolean dryRun) {
        JobConfigurationQuery queryConfig = new JobConfigurationQuery().setQuery(sqlQuery).setPriority(this.PRIORITY()).setCreateDisposition("CREATE_IF_NEEDED").setWriteDisposition("WRITE_EMPTY");
        if (destinationTable != null) {
            queryConfig = queryConfig.setDestinationTable(destinationTable).setAllowLargeResults(Predef$.MODULE$.boolean2Boolean(true));
        }
        JobConfiguration jobConfig = new JobConfiguration().setQuery(queryConfig).setDryRun(Predef$.MODULE$.boolean2Boolean(dryRun));
        JobReference jobReference = this.createJobReference(this.projectId(), this.JOB_ID_PREFIX());
        Job job = new Job().setConfiguration(jobConfig).setJobReference(jobReference);
        return (Job)this.bigquery().jobs().insert(this.projectId(), job).execute();
    }

    private JobReference createJobReference(String projectId, String jobIdPrefix) {
        String fullJobId = new StringBuilder().append((Object)projectId).append((Object)"-").append((Object)UUID.randomUUID().toString()).toString();
        return new JobReference().setProjectId(projectId).setJobId(fullJobId);
    }

    public BigQueryClient(Configuration conf) {
        this.com$spotify$spark$bigquery$BigQueryClient$$conf = conf;
        this.com$spotify$spark$bigquery$BigQueryClient$$logger = LoggerFactory.getLogger(BigQueryClient.class);
        this.SCOPES = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://www.googleapis.com/auth/bigquery"}))).asJava();
        GoogleCredential credential = GoogleCredential.getApplicationDefault().createScoped(this.SCOPES());
        this.bigquery = new Bigquery.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)credential).setApplicationName("spark-bigquery").build();
        this.queryCache = CacheBuilder.newBuilder().expireAfterWrite(BigQueryClient$.MODULE$.STAGING_DATASET_TABLE_EXPIRATION_MS(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<String, TableReference>(this){
            private final /* synthetic */ BigQueryClient $outer;

            public TableReference load(String key) {
                String sqlQuery = key;
                this.$outer.com$spotify$spark$bigquery$BigQueryClient$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Executing query ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlQuery})));
                String location = this.$outer.com$spotify$spark$bigquery$BigQueryClient$$conf.get(BigQueryClient$.MODULE$.STAGING_DATASET_LOCATION(), BigQueryClient$.MODULE$.STAGING_DATASET_LOCATION_DEFAULT());
                TableReference destinationTable = this.$outer.com$spotify$spark$bigquery$BigQueryClient$$temporaryTable(location);
                String tableName = BigQueryStrings.toString((TableReference)destinationTable);
                this.$outer.com$spotify$spark$bigquery$BigQueryClient$$logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Destination table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{destinationTable})));
                Job job = this.$outer.com$spotify$spark$bigquery$BigQueryClient$$createQueryJob(sqlQuery, destinationTable, false);
                this.$outer.com$spotify$spark$bigquery$BigQueryClient$$waitForJob(job);
                return destinationTable;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.PRIORITY = this.inConsole() ? "INTERACTIVE" : "BATCH";
        this.TABLE_ID_PREFIX = "spark_bigquery";
        this.JOB_ID_PREFIX = "spark_bigquery";
        this.TIME_FORMATTER = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
    }
}

