/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.hamcrest.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hamcrest.Description;
import org.hamcrest.StringDescription;

public final class DescriptionUtils {
    private static final Splitter LINE_SPLITTER = Splitter.on((char)'\n');
    private static final Joiner INDENTED_LINE_JOINER = Joiner.on((String)"\n  ");

    private DescriptionUtils() {
        throw new IllegalAccessError("This class may not be instantiated.");
    }

    public static void indentDescription(Description description, Description innerDescription) {
        Iterable lines = LINE_SPLITTER.split((CharSequence)innerDescription.toString().trim());
        String indentedLines = INDENTED_LINE_JOINER.join(lines);
        description.appendText(indentedLines).appendText("\n");
    }

    public static void describeNestedMismatches(Set<String> allKeys, Description mismatchDescription, Map<String, Consumer<Description>> mismatchedKeys, BiConsumer<String, Description> describeKey) {
        Preconditions.checkArgument((!mismatchedKeys.isEmpty() ? 1 : 0) != 0, (Object)"mismatchKeys must not be empty");
        String previousMismatchKey = null;
        String previousKey = null;
        mismatchDescription.appendText("{\n");
        for (String key : allKeys) {
            if (mismatchedKeys.containsKey(key)) {
                if (previousKey != null && !Objects.equals(previousMismatchKey, previousKey)) {
                    mismatchDescription.appendText("  ...\n");
                }
                DescriptionUtils.describeMismatchForKey(key, mismatchDescription, describeKey, mismatchedKeys.get(key));
                previousMismatchKey = key;
            }
            previousKey = key;
        }
        if (!Objects.equals(previousMismatchKey, previousKey)) {
            mismatchDescription.appendText("  ...\n");
        }
        mismatchDescription.appendText("}");
    }

    private static void describeMismatchForKey(String key, Description mismatchDescription, BiConsumer<String, Description> describeKey, Consumer<Description> innerAction) {
        mismatchDescription.appendText("  ");
        describeKey.accept(String.valueOf(key), mismatchDescription);
        mismatchDescription.appendText(": ");
        StringDescription innerDescription = new StringDescription();
        innerAction.accept((Description)innerDescription);
        DescriptionUtils.indentDescription(mismatchDescription, (Description)innerDescription);
    }
}

