/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

class CompletableToListenableFutureWrapper<V>
extends AbstractFuture<V>
implements ListenableFuture<V>,
BiConsumer<V, Throwable> {
    private final CompletionStage<V> future;

    CompletableToListenableFutureWrapper(CompletionStage<V> future) {
        this.future = future;
        future.whenComplete(this);
    }

    public CompletableFuture<V> unwrap() {
        return this.future.toCompletableFuture();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.future.toCompletableFuture().cancel(mayInterruptIfRunning);
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public void accept(V v, Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof CancellationException) {
                this.cancel(false);
            } else {
                this.setException(CompletableToListenableFutureWrapper.unwrapThrowable(throwable));
            }
        } else {
            this.set(v);
        }
    }

    static Throwable unwrapThrowable(Throwable throwable) {
        for (int i = 0; i < 100 && throwable instanceof CompletionException; ++i) {
            throwable = throwable.getCause();
        }
        return throwable;
    }
}

