/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.futures;

import com.google.api.core.ApiFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.spotify.futures.CompletableToListenableFutureWrapper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;

class CompletableToApiFutureWrapper<V>
extends AbstractFuture<V>
implements ApiFuture<V>,
BiConsumer<V, Throwable> {
    private final CompletionStage<V> future;

    CompletableToApiFutureWrapper(CompletionStage<V> future) {
        this.future = future;
        this.future.whenComplete(this);
    }

    public CompletableFuture<V> unwrap() {
        return this.future.toCompletableFuture();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.future.toCompletableFuture().cancel(mayInterruptIfRunning);
        return super.cancel(mayInterruptIfRunning);
    }

    @Override
    public void accept(V v, Throwable throwable) {
        if (throwable != null) {
            if (throwable instanceof CancellationException) {
                this.cancel(false);
            } else {
                this.setException(CompletableToListenableFutureWrapper.unwrapThrowable(throwable));
            }
        } else {
            this.set(v);
        }
    }
}

