/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.retry;

import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.MemcacheClosedException;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.futures.CompletableFutures;
import java.util.concurrent.CompletionStage;

public class RetryingClient
implements RawMemcacheClient {
    private final RawMemcacheClient delegate;

    public RetryingClient(RawMemcacheClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> CompletionStage<T> send(Request<T> request) {
        CompletionStage<T> future = this.delegate.send(request);
        return CompletableFutures.exceptionallyCompose(future, e -> {
            if ((e = Utils.unwrap(e)) instanceof MemcacheClosedException && this.delegate.isConnected()) {
                return this.delegate.send(request);
            }
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)e);
        });
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public Throwable getConnectionFailure() {
        return this.delegate.getConnectionFailure();
    }

    @Override
    public int numTotalConnections() {
        return this.delegate.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.delegate.numActiveConnections();
    }

    @Override
    public void registerForConnectionChanges(ConnectionChangeListener listener) {
        this.delegate.registerForConnectionChanges(listener);
    }

    @Override
    public void unregisterForConnectionChanges(ConnectionChangeListener listener) {
        this.delegate.unregisterForConnectionChanges(listener);
    }

    public String toString() {
        return "Retrying(" + this.delegate + ")";
    }
}

