/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.test;

import com.spotify.folsom.AbstractRawMemcacheClient;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheClosedException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.client.GetRequest;
import com.spotify.folsom.client.MultiRequest;
import com.spotify.folsom.client.NoopMetrics;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.SetRequest;
import com.spotify.folsom.client.ascii.DeleteRequest;
import com.spotify.folsom.client.ascii.IncrRequest;
import com.spotify.folsom.client.ascii.TouchRequest;
import com.spotify.futures.CompletableFutures;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class FakeRawMemcacheClient
extends AbstractRawMemcacheClient {
    private boolean connected = true;
    private final Map<ByteBuffer, byte[]> map = new HashMap<ByteBuffer, byte[]>();
    private int outstanding = 0;

    public FakeRawMemcacheClient() {
        this(new NoopMetrics());
    }

    public FakeRawMemcacheClient(Metrics metrics) {
        metrics.registerOutstandingRequestsGauge(() -> this.outstanding);
    }

    @Override
    public <T> CompletionStage<T> send(Request<T> request) {
        if (!this.connected) {
            return CompletableFutures.exceptionallyCompletedFuture((Throwable)new MemcacheClosedException("Disconnected"));
        }
        if (request instanceof SetRequest) {
            this.map.put(ByteBuffer.wrap(request.getKey()), ((SetRequest)((Object)request)).getValue());
            return CompletableFuture.completedFuture(MemcacheStatus.OK);
        }
        if (request instanceof GetRequest) {
            byte[] value = this.map.get(ByteBuffer.wrap(request.getKey()));
            if (value == null) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.completedFuture(GetResult.success(value, 0L));
        }
        if (request instanceof MultiRequest) {
            ArrayList<GetResult<byte[]>> result = new ArrayList<GetResult<byte[]>>();
            MultiRequest multiRequest = (MultiRequest)((Object)request);
            for (byte[] key : multiRequest.getKeys()) {
                byte[] value = this.map.get(ByteBuffer.wrap(key));
                if (value != null) {
                    result.add(GetResult.success(value, 0L));
                    continue;
                }
                result.add(null);
            }
            return CompletableFuture.completedFuture(result);
        }
        if (request instanceof TouchRequest) {
            return CompletableFuture.completedFuture(MemcacheStatus.OK);
        }
        if (request instanceof IncrRequest) {
            IncrRequest incrRequest = (IncrRequest)request;
            byte[] key = request.getKey();
            byte[] value = this.map.get(ByteBuffer.wrap(key));
            if (value == null) {
                return CompletableFuture.completedFuture(null);
            }
            long longValue = Long.parseLong(new String(value));
            long newValue = longValue + incrRequest.multiplier() * incrRequest.getBy();
            this.map.put(ByteBuffer.wrap(key), Long.toString(newValue).getBytes());
            return CompletableFuture.completedFuture(newValue);
        }
        if (request instanceof DeleteRequest) {
            this.map.remove(ByteBuffer.wrap(request.getKey()));
            return CompletableFuture.completedFuture(MemcacheStatus.OK);
        }
        throw new RuntimeException("Unsupported operation: " + request.getClass());
    }

    @Override
    public void shutdown() {
        this.connected = false;
        this.notifyConnectionChange();
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public Throwable getConnectionFailure() {
        return null;
    }

    @Override
    public int numTotalConnections() {
        return 1;
    }

    @Override
    public int numActiveConnections() {
        return this.connected ? 1 : 0;
    }

    public Map<ByteBuffer, byte[]> getMap() {
        return this.map;
    }

    public void setOutstandingRequests(int outstanding) {
        this.outstanding = outstanding;
    }
}

