/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;

public class BinaryMemcacheDecoder
extends ByteToMessageDecoder {
    private static final byte[] NO_BYTES = new byte[0];
    private static final int BATCH_SIZE = 16;
    private BinaryResponse replies = new BinaryResponse();

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        for (int i = 0; i < 16; ++i) {
            if (buf.readableBytes() < 24) {
                return;
            }
            buf.markReaderIndex();
            short magicNumber = buf.readUnsignedByte();
            if (magicNumber != 129) {
                throw this.fail(buf, String.format("Invalid magic number: 0x%2x", magicNumber));
            }
            OpCode opcode = OpCode.of(buf.readByte());
            int keyLength = buf.readUnsignedShort();
            short extrasLength = buf.readUnsignedByte();
            buf.skipBytes(1);
            int statusCode = buf.readUnsignedShort();
            MemcacheStatus status = MemcacheStatus.fromInt(statusCode);
            int totalLength = buf.readInt();
            int opaque = buf.readInt();
            long cas = buf.readLong();
            if (buf.readableBytes() < totalLength) {
                buf.resetReaderIndex();
                return;
            }
            buf.skipBytes((int)extrasLength);
            byte[] keyBytes = keyLength == 0 ? NO_BYTES : new byte[keyLength];
            buf.readBytes(keyBytes);
            int valueLength = totalLength - keyLength - extrasLength;
            byte[] valueBytes = valueLength == 0 ? NO_BYTES : new byte[valueLength];
            buf.readBytes(valueBytes);
            if (opcode == OpCode.STAT) {
                boolean endPacket;
                boolean bl = endPacket = keyLength == 0;
                if (endPacket) {
                    out.add(this.replies);
                    this.replies = new BinaryResponse();
                    continue;
                }
                this.replies.add(new ResponsePacket(opcode, status, opaque, cas, keyBytes, valueBytes));
                continue;
            }
            this.replies.add(new ResponsePacket(opcode, status, opaque, cas, keyBytes, valueBytes));
            if ((opaque & 0xFF) != 0) continue;
            out.add(this.replies);
            this.replies = new BinaryResponse();
        }
    }

    private IOException fail(ByteBuf buf, String message) {
        buf.resetReaderIndex();
        return new IOException(message);
    }
}

