/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class DeleteRequest
extends AsciiRequest<MemcacheStatus> {
    private static final byte[] CMD_BYTES = "delete ".getBytes(StandardCharsets.US_ASCII);

    public DeleteRequest(byte[] key) {
        super(key);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD_BYTES);
        dst.put(this.key);
        dst.put(NEWLINE_BYTES);
        return DeleteRequest.toBuffer(alloc, dst);
    }

    @Override
    public void handle(AsciiResponse response, HostAndPort server) throws IOException {
        switch (response.type) {
            case DELETED: {
                this.succeed(MemcacheStatus.OK);
                return;
            }
            case NOT_FOUND: {
                this.succeed(MemcacheStatus.KEY_NOT_FOUND);
                return;
            }
        }
        throw new IOException("Unexpected response type: " + (Object)((Object)response.type));
    }
}

