/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.google.common.collect.Lists;
import com.spotify.folsom.AsciiMemcacheClient;
import com.spotify.folsom.ConnectionChangeListener;
import com.spotify.folsom.GetResult;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.MemcachedStats;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.Tracer;
import com.spotify.folsom.Transcoder;
import com.spotify.folsom.client.AbstractRequest;
import com.spotify.folsom.client.TransformerUtil;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.ascii.DeleteAllRequest;
import com.spotify.folsom.client.ascii.DeleteRequest;
import com.spotify.folsom.client.ascii.DeleteWithCasRequest;
import com.spotify.folsom.client.ascii.FlushRequest;
import com.spotify.folsom.client.ascii.GetRequest;
import com.spotify.folsom.client.ascii.IncrRequest;
import com.spotify.folsom.client.ascii.MultigetRequest;
import com.spotify.folsom.client.ascii.SetRequest;
import com.spotify.folsom.client.ascii.StatsRequest;
import com.spotify.folsom.client.ascii.TouchRequest;
import com.spotify.futures.CompletableFutures;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class DefaultAsciiMemcacheClient<V>
implements AsciiMemcacheClient<V> {
    private final RawMemcacheClient rawMemcacheClient;
    private final Metrics metrics;
    private final Tracer tracer;
    private final Transcoder<V> valueTranscoder;
    private final TransformerUtil<V> transformerUtil;
    private final Charset charset;
    private final int maxKeyLength;

    public DefaultAsciiMemcacheClient(RawMemcacheClient rawMemcacheClient, Metrics metrics, Tracer tracer, Transcoder<V> valueTranscoder, Charset charset, int maxKeyLength) {
        this.rawMemcacheClient = rawMemcacheClient;
        this.metrics = metrics;
        this.tracer = tracer;
        this.valueTranscoder = valueTranscoder;
        this.charset = charset;
        this.transformerUtil = new TransformerUtil<V>(valueTranscoder);
        this.maxKeyLength = maxKeyLength;
    }

    @Override
    public CompletionStage<MemcacheStatus> set(String key, V value, int ttl) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = SetRequest.create(SetRequest.Operation.SET, AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), valueBytes, ttl);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.tracer.span("folsom.set", future, "set", key, valueBytes);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> set(String key, V value, int ttl, long cas) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        byte[] byteKey = AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength);
        SetRequest request = SetRequest.casSet(byteKey, valueBytes, ttl, cas);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.tracer.span("folsom.set", future, "set", key, valueBytes);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> delete(String key) {
        DeleteRequest request = new DeleteRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength));
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        this.tracer.span("folsom.delete", future, "delete", key);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> delete(String key, long cas) {
        DeleteWithCasRequest request = new DeleteWithCasRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), cas);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        this.tracer.span("folsom.deleteWithCas", future, "delete", key);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> deleteAll(String key) {
        DeleteAllRequest request = new DeleteAllRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength));
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureDeleteFuture(future);
        this.tracer.span("folsom.delete_all", future, "delete", key);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> add(String key, V value, int ttl) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = SetRequest.create(SetRequest.Operation.ADD, AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), valueBytes, ttl);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.tracer.span("folsom.add", future, "add", key, valueBytes);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> replace(String key, V value, int ttl) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = SetRequest.create(SetRequest.Operation.REPLACE, AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), valueBytes, ttl);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.tracer.span("folsom.replace", future, "replace", key, valueBytes);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> append(String key, V value) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = SetRequest.create(SetRequest.Operation.APPEND, AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), valueBytes, 0);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.tracer.span("folsom.append", future, "append", key, valueBytes);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> prepend(String key, V value) {
        Objects.requireNonNull(value);
        byte[] valueBytes = this.valueTranscoder.encode(value);
        SetRequest request = SetRequest.create(SetRequest.Operation.PREPEND, AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), valueBytes, 0);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureSetFuture(future);
        this.tracer.span("folsom.prepend", future, "prepend", key, valueBytes);
        return future;
    }

    @Override
    public CompletionStage<Long> incr(String key, long by) {
        IncrRequest request = IncrRequest.createIncr(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), by);
        CompletionStage<Long> future = this.rawMemcacheClient.send(request);
        this.metrics.measureIncrDecrFuture(future);
        this.tracer.span("folsom.incr", future, "incr", key);
        return future;
    }

    @Override
    public CompletionStage<Long> decr(String key, long by) {
        IncrRequest request = IncrRequest.createDecr(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), by);
        CompletionStage<Long> future = this.rawMemcacheClient.send(request);
        this.metrics.measureIncrDecrFuture(future);
        this.tracer.span("folsom.decr", future, "decr", key);
        return future;
    }

    @Override
    public CompletionStage<V> get(String key) {
        return this.transformerUtil.unwrap(this.get(key, false));
    }

    @Override
    public CompletionStage<GetResult<V>> casGet(String key) {
        return this.get(key, true);
    }

    private CompletionStage<GetResult<V>> get(String key, boolean withCas) {
        CompletionStage<GetResult<byte[]>> future = this.rawMemcacheClient.send(new GetRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), withCas));
        this.metrics.measureGetFuture(future);
        this.tracer.span("folsom.get", future, "get", key);
        return this.transformerUtil.decode(future);
    }

    @Override
    public CompletionStage<List<V>> get(List<String> keys) {
        List<byte[]> byteKeys = AbstractRequest.encodeKeys(keys, this.charset, this.maxKeyLength);
        return this.transformerUtil.unwrapList(this.multiget(byteKeys, false));
    }

    @Override
    public CompletionStage<List<GetResult<V>>> casGet(List<String> keys) {
        List<byte[]> byteKeys = AbstractRequest.encodeKeys(keys, this.charset, this.maxKeyLength);
        return this.multiget(byteKeys, true);
    }

    @Override
    public CompletionStage<MemcacheStatus> touch(String key, int ttl) {
        TouchRequest request = new TouchRequest(AbstractRequest.encodeKey(key, this.charset, this.maxKeyLength), ttl);
        CompletionStage<MemcacheStatus> future = this.rawMemcacheClient.send(request);
        this.metrics.measureTouchFuture(future);
        this.tracer.span("folsom.touch", future, "touch", key);
        return future;
    }

    @Override
    public CompletionStage<MemcacheStatus> flushAll(int delay) {
        return this.rawMemcacheClient.send(new FlushRequest(delay));
    }

    private CompletionStage<List<GetResult<V>>> multiget(List<byte[]> keys, boolean withCas) {
        int size = keys.size();
        if (size == 0) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List keyPartition = Lists.partition(keys, (int)255);
        ArrayList<CompletionStage<List<GetResult<byte[]>>>> futureList = new ArrayList<CompletionStage<List<GetResult<byte[]>>>>(keyPartition.size());
        for (List part : keyPartition) {
            MultigetRequest request = MultigetRequest.create(part, withCas);
            futureList.add(this.rawMemcacheClient.send(request));
        }
        CompletionStage<List<GetResult<byte[]>>> future = CompletableFutures.allAsList(futureList).thenApply(Utils.flatten());
        this.metrics.measureMultigetFuture(future);
        this.tracer.span("folsom.multiget", future, "get");
        return this.transformerUtil.decodeList(future);
    }

    @Override
    public void shutdown() {
        this.rawMemcacheClient.shutdown();
    }

    @Override
    public void registerForConnectionChanges(ConnectionChangeListener listener) {
        this.rawMemcacheClient.registerForConnectionChanges(listener);
    }

    @Override
    public void unregisterForConnectionChanges(ConnectionChangeListener listener) {
        this.rawMemcacheClient.unregisterForConnectionChanges(listener);
    }

    @Override
    public boolean isConnected() {
        return this.rawMemcacheClient.isConnected();
    }

    @Override
    public Throwable getConnectionFailure() {
        return this.rawMemcacheClient.getConnectionFailure();
    }

    @Override
    public int numTotalConnections() {
        return this.rawMemcacheClient.numTotalConnections();
    }

    @Override
    public int numActiveConnections() {
        return this.rawMemcacheClient.numActiveConnections();
    }

    public String toString() {
        return "AsciiMemcacheClient(" + this.rawMemcacheClient + ")";
    }

    @Override
    public RawMemcacheClient getRawMemcacheClient() {
        return this.rawMemcacheClient;
    }

    @Override
    public CompletionStage<Map<String, MemcachedStats>> getStats(String key) {
        return this.rawMemcacheClient.send(new StatsRequest(key));
    }
}

