/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.spotify.folsom.client.DefaultRawMemcacheClient;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;

public final class Utils {
    private static final int TTL_CUTOFF = 2592000;

    private Utils() {
    }

    public static int ttlToExpiration(int ttl) {
        if (ttl <= 0) {
            return 0;
        }
        if (ttl < 2592000) {
            return ttl;
        }
        int expirationTime = (int)(System.currentTimeMillis() / 1000L) + ttl;
        if (expirationTime < 0) {
            return 0x7FFFFFFE;
        }
        return expirationTime;
    }

    public static <T> Function<List<List<T>>, List<T>> flatten() {
        return input -> Lists.newArrayList((Iterable)Iterables.concat((Iterable)input));
    }

    public static int getGlobalConnectionCount() {
        return DefaultRawMemcacheClient.getGlobalConnectionCount();
    }

    public static Throwable unwrap(Throwable e) {
        if (e instanceof ExecutionException || e instanceof CompletionException) {
            return Utils.unwrap(e.getCause());
        }
        return e;
    }

    static <T> CompletionStage<T> onExecutor(CompletionStage<T> future, Executor executor) {
        if (executor == null) {
            return future;
        }
        return future.whenCompleteAsync((t, throwable) -> {}, executor);
    }
}

