/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.reconnect;

import com.spotify.folsom.guava.HostAndPort;
import com.spotify.folsom.reconnect.ReconnectionListener;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchingReconnectionListener
implements ReconnectionListener {
    private static final Logger log = LoggerFactory.getLogger(CatchingReconnectionListener.class);
    private final ReconnectionListener delegate;

    public CatchingReconnectionListener(ReconnectionListener delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
    }

    @Override
    public void connectionFailure(Throwable cause) {
        try {
            this.delegate.connectionFailure(cause);
        }
        catch (Exception ex) {
            log.warn("Delegate ReconnectionListener threw on #connectionFailure: {}", (Object)this.delegate, (Object)ex);
        }
    }

    @Override
    public void reconnectionCancelled() {
        try {
            this.delegate.reconnectionCancelled();
        }
        catch (Exception ex) {
            log.warn("Delegate ReconnectionListener threw on #reconnectionCancelled: {}", (Object)this.delegate, (Object)ex);
        }
    }

    @Override
    public void reconnectionSuccessful(HostAndPort address, int attempt, boolean willStayConnected) {
        try {
            this.delegate.reconnectionSuccessful(address, attempt, willStayConnected);
        }
        catch (Exception ex) {
            log.warn("Delegate ReconnectionListener threw on #reconnectionSuccessful: {}", (Object)this.delegate, (Object)ex);
        }
    }

    @Override
    public void connectionLost(@Nullable Throwable cause, HostAndPort address) {
        try {
            this.delegate.connectionLost(cause, address);
        }
        catch (Exception ex) {
            log.warn("Delegate ReconnectionListener threw on #connectionLost: {}", (Object)this.delegate, (Object)ex);
        }
    }

    @Override
    public void reconnectionQueuedFromError(Throwable cause, HostAndPort address, long backOffMillis, int attempt) {
        try {
            this.delegate.reconnectionQueuedFromError(cause, address, backOffMillis, attempt);
        }
        catch (Exception ex) {
            log.warn("Delegate ReconnectionListener threw on #reconnectionQueuedFromError: {}", (Object)this.delegate, (Object)ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatchingReconnectionListener)) {
            return false;
        }
        CatchingReconnectionListener that = (CatchingReconnectionListener)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public String toString() {
        return "CatchingReconnectionListener{delegate=" + this.delegate + '}';
    }
}

