/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.binary;

import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.OpCode;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.binary.BinaryRequest;
import com.spotify.folsom.client.binary.BinaryResponse;
import com.spotify.folsom.client.binary.ResponsePacket;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TouchRequest
extends BinaryRequest<MemcacheStatus> {
    private final int ttl;

    public TouchRequest(byte[] key, int ttl) {
        super(key);
        this.ttl = ttl;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        int expiration = Utils.ttlToExpiration(this.ttl);
        int extrasLength = 4;
        this.writeHeader(dst, OpCode.TOUCH, 4, 0, 0L);
        dst.putInt(expiration);
        dst.put(this.key);
        return TouchRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new TouchRequest(this.key, this.ttl);
    }

    @Override
    public void handle(BinaryResponse replies, HostAndPort server) throws IOException {
        ResponsePacket reply = this.handleSingleReply(replies);
        this.succeed(reply.status);
    }
}

