/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.client.ascii.NumericAsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class IncrRequest
extends AsciiRequest<Long> {
    private static final byte[] INCR_CMD = "incr ".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] DECR_CMD = "decr ".getBytes(StandardCharsets.US_ASCII);
    private final byte[] operation;
    private final long by;

    private IncrRequest(byte[] operation, byte[] key, long by) {
        super(key);
        this.operation = operation;
        this.by = by;
    }

    public static IncrRequest createIncr(byte[] key, long value) {
        return new IncrRequest(INCR_CMD, key, value);
    }

    public static IncrRequest createDecr(byte[] key, long value) {
        return new IncrRequest(DECR_CMD, key, value);
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(this.operation);
        dst.put(this.key);
        dst.put((byte)32);
        dst.put(String.valueOf(this.by).getBytes());
        dst.put(NEWLINE_BYTES);
        return IncrRequest.toBuffer(alloc, dst);
    }

    @Override
    public Request<Long> duplicate() {
        return new IncrRequest(this.operation, this.key, this.by);
    }

    @Override
    public void handle(AsciiResponse response, HostAndPort server) throws IOException {
        if (response instanceof NumericAsciiResponse) {
            this.succeed(((NumericAsciiResponse)response).numericValue);
        } else if (response.type == AsciiResponse.Type.NOT_FOUND) {
            this.succeed(null);
        } else if (response.type == AsciiResponse.Type.CLIENT_ERROR) {
            MemcacheAuthenticationException exception = new MemcacheAuthenticationException("Authentication required by server. Client not authenticated.");
            this.fail(exception, server);
        } else {
            throw new IOException("Unexpected response type: " + (Object)((Object)response.type));
        }
    }

    public long getBy() {
        return this.by;
    }

    public long multiplier() {
        return this.operation == INCR_CMD ? 1L : -1L;
    }
}

