/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.client.ascii;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.client.AllRequest;
import com.spotify.folsom.client.Request;
import com.spotify.folsom.client.Utils;
import com.spotify.folsom.client.ascii.AsciiRequest;
import com.spotify.folsom.client.ascii.AsciiResponse;
import com.spotify.folsom.guava.HostAndPort;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class FlushRequest
extends AsciiRequest<MemcacheStatus>
implements AllRequest<MemcacheStatus> {
    private static final byte[] CMD = "flush_all ".getBytes();
    private static final byte[] NO_KEY = new byte[0];
    private final int delay;

    public FlushRequest(int delay) {
        super(NO_KEY);
        this.delay = delay;
    }

    @Override
    public ByteBuf writeRequest(ByteBufAllocator alloc, ByteBuffer dst) {
        dst.put(CMD);
        dst.put(String.valueOf(Utils.ttlToExpiration(this.delay)).getBytes());
        dst.put(NEWLINE_BYTES);
        return FlushRequest.toBuffer(alloc, dst);
    }

    @Override
    protected void handle(AsciiResponse response, HostAndPort server) throws IOException {
        AsciiResponse.Type type = response.type;
        if (type == AsciiResponse.Type.OK) {
            this.succeed(MemcacheStatus.OK);
        } else if (type == AsciiResponse.Type.CLIENT_ERROR) {
            MemcacheAuthenticationException exception = new MemcacheAuthenticationException("Authentication required by server. Client not authenticated.");
            this.fail(exception, server);
        } else {
            throw new IOException("Unexpected line: " + (Object)((Object)type));
        }
    }

    @Override
    public MemcacheStatus merge(List<MemcacheStatus> results) {
        return AllRequest.mergeMemcacheStatus(results);
    }

    @Override
    public Request<MemcacheStatus> duplicate() {
        return new FlushRequest(this.delay);
    }
}

