/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom.authenticate;

import com.spotify.folsom.MemcacheAuthenticationException;
import com.spotify.folsom.MemcacheStatus;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.authenticate.Authenticator;
import com.spotify.folsom.client.ascii.AsciiAuthenticateRequest;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

public class AsciiAuthenticator
implements Authenticator {
    private final String username;
    private final String password;

    public AsciiAuthenticator(String username, String password) {
        this.username = Objects.requireNonNull(username);
        this.password = Objects.requireNonNull(password);
    }

    @Override
    public CompletionStage<RawMemcacheClient> authenticate(RawMemcacheClient client) {
        AsciiAuthenticateRequest asciiAuthenticateRequest = new AsciiAuthenticateRequest(this.username, this.password);
        return client.connectFuture().thenCompose(ignored -> client.send(asciiAuthenticateRequest).thenApply(status -> {
            if (status == MemcacheStatus.OK) {
                return client;
            }
            if (status == MemcacheStatus.UNAUTHORIZED) {
                throw new MemcacheAuthenticationException("Authentication failed");
            }
            throw new RuntimeException("Unexpected status: " + status.name());
        }));
    }

    @Override
    public void validate(boolean binary) {
        if (binary) {
            throw new IllegalStateException("Programmer error: wrong validator used");
        }
    }
}

