/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import java.io.IOException;

public enum MemcacheStatus {
    OK,
    KEY_NOT_FOUND,
    KEY_EXISTS,
    VALUE_TOO_LARGE,
    INVALID_ARGUMENTS,
    ITEM_NOT_STORED,
    INCR_DECR_ON_NON_NUMERIC_VALUE,
    THE_VBUCKET_BELONGS_TO_ANOTHER_SERVER,
    AUTHENTICATION_ERROR,
    AUTHENTICATION_CONTINUE,
    UNKNOWN_COMMAND,
    OUT_OF_MEMORY,
    NOT_SUPPORTED,
    INTERNAL_ERROR,
    BUSY,
    TEMPORARY_FAILURE,
    UNAUTHORIZED;


    public static MemcacheStatus fromInt(int status) throws IOException {
        switch (status) {
            case 0: {
                return OK;
            }
            case 1: {
                return KEY_NOT_FOUND;
            }
            case 2: {
                return KEY_EXISTS;
            }
            case 3: {
                return VALUE_TOO_LARGE;
            }
            case 4: {
                return INVALID_ARGUMENTS;
            }
            case 5: {
                return ITEM_NOT_STORED;
            }
            case 6: {
                return INCR_DECR_ON_NON_NUMERIC_VALUE;
            }
            case 7: {
                return THE_VBUCKET_BELONGS_TO_ANOTHER_SERVER;
            }
            case 8: {
                return AUTHENTICATION_ERROR;
            }
            case 9: {
                return AUTHENTICATION_CONTINUE;
            }
            case 32: {
                return UNAUTHORIZED;
            }
            case 129: {
                return UNKNOWN_COMMAND;
            }
            case 130: {
                return OUT_OF_MEMORY;
            }
            case 131: {
                return NOT_SUPPORTED;
            }
            case 132: {
                return INTERNAL_ERROR;
            }
            case 133: {
                return BUSY;
            }
            case 134: {
                return TEMPORARY_FAILURE;
            }
        }
        throw new IOException(String.format("Unknown status code: 0x%2x", status));
    }
}

