/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.folsom;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.folsom.AsciiMemcacheClient;
import com.spotify.folsom.BackoffFunction;
import com.spotify.folsom.BinaryMemcacheClient;
import com.spotify.folsom.ExponentialBackoff;
import com.spotify.folsom.Metrics;
import com.spotify.folsom.RawMemcacheClient;
import com.spotify.folsom.Resolver;
import com.spotify.folsom.SrvResolver;
import com.spotify.folsom.Tracer;
import com.spotify.folsom.Transcoder;
import com.spotify.folsom.UncaughtExceptionHandler;
import com.spotify.folsom.authenticate.AsciiAuthenticationValidator;
import com.spotify.folsom.authenticate.Authenticator;
import com.spotify.folsom.authenticate.BinaryAuthenticationValidator;
import com.spotify.folsom.authenticate.MultiAuthenticator;
import com.spotify.folsom.authenticate.NoAuthenticationValidation;
import com.spotify.folsom.authenticate.UsernamePasswordPair;
import com.spotify.folsom.client.NoopMetrics;
import com.spotify.folsom.client.NoopTracer;
import com.spotify.folsom.client.ascii.DefaultAsciiMemcacheClient;
import com.spotify.folsom.client.binary.DefaultBinaryMemcacheClient;
import com.spotify.folsom.client.tls.SSLEngineFactory;
import com.spotify.folsom.guava.HostAndPort;
import com.spotify.folsom.ketama.AddressAndClient;
import com.spotify.folsom.ketama.Continuum;
import com.spotify.folsom.ketama.KetamaMemcacheClient;
import com.spotify.folsom.ketama.NodeLocator;
import com.spotify.folsom.ketama.ResolvingKetamaClient;
import com.spotify.folsom.reconnect.CatchingReconnectionListener;
import com.spotify.folsom.reconnect.ReconnectingClient;
import com.spotify.folsom.reconnect.ReconnectionListener;
import com.spotify.folsom.retry.RetryingClient;
import com.spotify.folsom.roundrobin.RoundRobinMemcacheClient;
import com.spotify.folsom.transcoder.ByteArrayTranscoder;
import com.spotify.folsom.transcoder.SerializableObjectTranscoder;
import com.spotify.folsom.transcoder.StringTranscoder;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MemcacheClientBuilder<V> {
    private static final int DEFAULT_MAX_SET_LENGTH = 0x100000;
    private static final int DEFAULT_MAX_OUTSTANDING = 1000;
    private static final String DEFAULT_HOSTNAME = "127.0.0.1";
    private static final int DEFAULT_PORT = 11211;
    private static final Supplier<Executor> DEFAULT_REPLY_EXECUTOR = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> new ForkJoinPool(Runtime.getRuntime().availableProcessors(), ForkJoinPool.defaultForkJoinWorkerThreadFactory, new UncaughtExceptionHandler(), true))).get();
    private static final Supplier<ScheduledExecutorService> DEFAULT_SCHEDULED_EXECUTOR = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("folsom-default-scheduled-executor").build()))).get();
    private final List<HostAndPort> addresses = new ArrayList<HostAndPort>();
    private int maxOutstandingRequests = 1000;
    private int eventLoopThreadFlushMaxBatchSize = 64;
    private final Transcoder<V> valueTranscoder;
    private Metrics metrics = NoopMetrics.INSTANCE;
    private Tracer tracer = NoopTracer.INSTANCE;
    private ReconnectionListener reconnectionListener = new ReconnectingClient.StandardReconnectionListener();
    private BackoffFunction backoffFunction = new ExponentialBackoff(10L, 60000L, 2.5);
    private int connections = 1;
    private boolean retry = true;
    private Supplier<Executor> executor = DEFAULT_REPLY_EXECUTOR;
    private Charset charset = StandardCharsets.UTF_8;
    private Resolver resolver;
    private DnsSrvResolver srvResolver;
    private String srvRecord;
    private long resolveRefreshPeriod = 60000L;
    private long shutdownDelay = 60000L;
    private long connectionTimeoutMillis = 3000L;
    private int maxSetLength = 0x100000;
    private int maxKeyLength = 250;
    private EventLoopGroup eventLoopGroup;
    private Class<? extends Channel> channelClass;
    private final List<UsernamePasswordPair> passwords = new ArrayList<UsernamePasswordPair>();
    private boolean skipAuth = false;
    private Function<Collection<AddressAndClient>, NodeLocator> nodeLocator = Continuum::new;
    private SSLEngineFactory sslEngineFactory = null;

    public static MemcacheClientBuilder<byte[]> newByteArrayClient() {
        return new MemcacheClientBuilder<byte[]>(ByteArrayTranscoder.INSTANCE);
    }

    public static MemcacheClientBuilder<String> newStringClient() {
        return MemcacheClientBuilder.newStringClient(StandardCharsets.UTF_8);
    }

    public static MemcacheClientBuilder<String> newStringClient(Charset charset) {
        return new MemcacheClientBuilder<String>(new StringTranscoder(charset));
    }

    public static <T extends Serializable> MemcacheClientBuilder<T> newSerializableObjectClient() {
        return new MemcacheClientBuilder(SerializableObjectTranscoder.getInstance());
    }

    public MemcacheClientBuilder(Transcoder<V> valueTranscoder) {
        this.valueTranscoder = valueTranscoder;
    }

    public MemcacheClientBuilder<V> withKeyCharset(Charset charset) {
        this.charset = Objects.requireNonNull(charset);
        return this;
    }

    public MemcacheClientBuilder<V> withAddress(String hostname) {
        return this.withAddress(hostname, 11211);
    }

    public MemcacheClientBuilder<V> withAddress(String host, int port) {
        this.addresses.add(HostAndPort.fromParts(host, port));
        return this;
    }

    public MemcacheClientBuilder<V> withResolver(Resolver resolver) {
        this.resolver = Objects.requireNonNull(resolver);
        return this;
    }

    private void updateResolver() {
        if (this.srvRecord != null) {
            SrvResolver.Builder builder = SrvResolver.newBuilder(this.srvRecord);
            if (this.srvResolver != null) {
                builder.withSrvResolver(this.srvResolver);
            }
            this.resolver = builder.build();
        } else {
            this.resolver = null;
        }
    }

    @Deprecated
    public MemcacheClientBuilder<V> withSRVRecord(String srvRecord) {
        this.srvRecord = Objects.requireNonNull(srvRecord);
        this.updateResolver();
        return this;
    }

    public MemcacheClientBuilder<V> withResolveRefreshPeriod(long periodMillis) {
        this.resolveRefreshPeriod = periodMillis;
        return this;
    }

    @Deprecated
    public MemcacheClientBuilder<V> withSRVRefreshPeriod(long periodMillis) {
        return this.withResolveRefreshPeriod(periodMillis);
    }

    public MemcacheClientBuilder<V> withResolveShutdownDelay(long shutdownDelay) {
        this.shutdownDelay = shutdownDelay;
        return this;
    }

    @Deprecated
    public MemcacheClientBuilder<V> withSRVShutdownDelay(long shutdownDelay) {
        return this.withResolveShutdownDelay(shutdownDelay);
    }

    @Deprecated
    public MemcacheClientBuilder<V> withSrvResolver(DnsSrvResolver srvResolver) {
        this.srvResolver = Objects.requireNonNull(srvResolver, "srvResolver");
        this.updateResolver();
        return this;
    }

    public MemcacheClientBuilder<V> withMetrics(Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
        return this;
    }

    public MemcacheClientBuilder<V> withTracer(Tracer tracer) {
        this.tracer = Objects.requireNonNull(tracer);
        return this;
    }

    public MemcacheClientBuilder<V> withReconnectionListener(ReconnectionListener reconnectionListener) {
        Objects.requireNonNull(reconnectionListener, "reconnectionListener cannot be null");
        this.reconnectionListener = new CatchingReconnectionListener(reconnectionListener);
        return this;
    }

    public MemcacheClientBuilder<V> withMaxOutstandingRequests(int maxOutstandingRequests) {
        this.maxOutstandingRequests = maxOutstandingRequests;
        return this;
    }

    @Deprecated
    public MemcacheClientBuilder<V> withRequestBatchSize(int eventLoopThreadFlushMaxBatchSize) {
        return this.withEventLoopThreadFlushMaxBatchSize(eventLoopThreadFlushMaxBatchSize);
    }

    public MemcacheClientBuilder<V> withEventLoopThreadFlushMaxBatchSize(int eventLoopThreadFlushMaxBatchSize) {
        Preconditions.checkArgument((eventLoopThreadFlushMaxBatchSize > 0 ? 1 : 0) != 0, (Object)"batch size must be > 0");
        this.eventLoopThreadFlushMaxBatchSize = eventLoopThreadFlushMaxBatchSize;
        return this;
    }

    public MemcacheClientBuilder<V> withBackoff(BackoffFunction backoffFunction) {
        this.backoffFunction = backoffFunction;
        return this;
    }

    public MemcacheClientBuilder<V> withRetry(boolean retry) {
        this.retry = retry;
        return this;
    }

    public MemcacheClientBuilder<V> withReplyExecutor(Executor executor) {
        this.executor = () -> ((com.google.common.base.Supplier)Suppliers.ofInstance((Object)executor)).get();
        return this;
    }

    public MemcacheClientBuilder<V> withConnections(int connections) {
        if (connections < 1) {
            throw new IllegalArgumentException("connections must be at least 1");
        }
        this.connections = connections;
        return this;
    }

    @Deprecated
    public MemcacheClientBuilder<V> withRequestTimeoutMillis(long timeoutMillis) {
        return this.withConnectionTimeoutMillis(timeoutMillis);
    }

    public MemcacheClientBuilder<V> withConnectionTimeoutMillis(long timeoutMillis) {
        this.connectionTimeoutMillis = timeoutMillis;
        return this;
    }

    public MemcacheClientBuilder<V> withMaxSetLength(int maxSetLength) {
        this.maxSetLength = maxSetLength;
        return this;
    }

    public MemcacheClientBuilder<V> withEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.eventLoopGroup = eventLoopGroup;
        return this;
    }

    public MemcacheClientBuilder<V> withChannelClass(Class<? extends Channel> channelClass) {
        this.channelClass = channelClass;
        return this;
    }

    public MemcacheClientBuilder<V> withMaxKeyLength(int maxKeyLength) {
        if (maxKeyLength < 0) {
            throw new IllegalArgumentException("maxKeyLength must be non-negative");
        }
        if (maxKeyLength > 250) {
            throw new IllegalArgumentException("maxKeyLength must be smaller than 250 but was " + maxKeyLength);
        }
        this.maxKeyLength = maxKeyLength;
        return this;
    }

    public MemcacheClientBuilder<V> withUsernamePassword(String username, String password) {
        this.passwords.add(new UsernamePasswordPair(username, password));
        return this;
    }

    public MemcacheClientBuilder<V> withNodeLocator(Function<Collection<AddressAndClient>, NodeLocator> nodeLocator) {
        this.nodeLocator = nodeLocator;
        return this;
    }

    MemcacheClientBuilder<V> withoutAuthenticationValidation() {
        this.skipAuth = true;
        return this;
    }

    public MemcacheClientBuilder<V> withSSLEngineFactory(SSLEngineFactory sslEngineFactory) {
        this.sslEngineFactory = sslEngineFactory;
        return this;
    }

    public BinaryMemcacheClient<V> connectBinary() {
        Authenticator authenticator = this.getAuthenticator(BinaryAuthenticationValidator.getInstance());
        authenticator.validate(true);
        return new DefaultBinaryMemcacheClient<V>(this.connectRaw(true, authenticator), this.metrics, this.tracer, this.valueTranscoder, this.charset, this.maxKeyLength);
    }

    private Authenticator getAuthenticator(Authenticator defaultValue) {
        if (this.skipAuth) {
            if (!this.passwords.isEmpty()) {
                throw new IllegalStateException("You may not specify both withoutAuthenticationValidation() and withUsernamePassword()");
            }
            return NoAuthenticationValidation.getInstance();
        }
        if (this.passwords.isEmpty()) {
            return defaultValue;
        }
        if (defaultValue instanceof BinaryAuthenticationValidator) {
            List authenticatorList = this.passwords.stream().map(UsernamePasswordPair::getPlainTextAuthenticator).collect(Collectors.toList());
            return new MultiAuthenticator(authenticatorList);
        }
        if (defaultValue instanceof AsciiAuthenticationValidator) {
            List authenticatorList = this.passwords.stream().map(UsernamePasswordPair::getAsciiAuthenticator).collect(Collectors.toList());
            return new MultiAuthenticator(authenticatorList);
        }
        throw new IllegalStateException("Only ASCII and binary protocols support authentication.");
    }

    public AsciiMemcacheClient<V> connectAscii() {
        Authenticator authenticator = this.getAuthenticator(AsciiAuthenticationValidator.getInstance());
        authenticator.validate(false);
        return new DefaultAsciiMemcacheClient<V>(this.connectRaw(false, authenticator), this.metrics, this.tracer, this.valueTranscoder, this.charset, this.maxKeyLength);
    }

    protected RawMemcacheClient connectRaw(boolean binary, Authenticator authenticator) {
        RawMemcacheClient client;
        ImmutableList addresses = this.addresses;
        if (this.resolver != null) {
            if (!addresses.isEmpty()) {
                throw new IllegalStateException("You may not specify both a resolver and addresses");
            }
            client = this.createResolvingClient(binary, authenticator);
        } else {
            if (addresses.isEmpty()) {
                addresses = ImmutableList.of((Object)HostAndPort.fromParts(DEFAULT_HOSTNAME, 11211));
            }
            List<RawMemcacheClient> clients = this.createClients((List<HostAndPort>)addresses, binary, authenticator);
            if (addresses.size() > 1) {
                Preconditions.checkState((clients.size() == addresses.size() ? 1 : 0) != 0);
                ArrayList<AddressAndClient> aac = new ArrayList<AddressAndClient>(clients.size());
                for (int i = 0; i < clients.size(); ++i) {
                    HostAndPort address = (HostAndPort)addresses.get(i);
                    aac.add(new AddressAndClient(address, clients.get(i)));
                }
                client = new KetamaMemcacheClient(aac, this.nodeLocator.apply(aac));
            } else {
                client = clients.get(0);
            }
        }
        if (this.retry) {
            return new RetryingClient(client);
        }
        return client;
    }

    private List<RawMemcacheClient> createClients(List<HostAndPort> addresses, boolean binary, Authenticator authenticator) {
        ArrayList<RawMemcacheClient> clients = new ArrayList<RawMemcacheClient>(addresses.size());
        for (HostAndPort address : addresses) {
            clients.add(this.createClient(address, binary, authenticator));
        }
        return clients;
    }

    private RawMemcacheClient createResolvingClient(boolean binary, Authenticator authenticator) {
        ResolvingKetamaClient client = new ResolvingKetamaClient(this.resolver, DEFAULT_SCHEDULED_EXECUTOR.get(), this.resolveRefreshPeriod, TimeUnit.MILLISECONDS, input -> this.createClient(input, binary, authenticator), this.shutdownDelay, TimeUnit.MILLISECONDS, this.nodeLocator);
        client.start();
        return client;
    }

    private RawMemcacheClient createClient(HostAndPort address, boolean binary, Authenticator authenticator) {
        if (this.connections == 1) {
            return this.createReconnectingClient(address, binary, authenticator);
        }
        ArrayList<RawMemcacheClient> clients = new ArrayList<RawMemcacheClient>();
        for (int i = 0; i < this.connections; ++i) {
            clients.add(this.createReconnectingClient(address, binary, authenticator));
        }
        return new RoundRobinMemcacheClient((List<RawMemcacheClient>)clients);
    }

    private RawMemcacheClient createReconnectingClient(HostAndPort address, boolean binary, Authenticator authenticator) {
        return new ReconnectingClient(this.backoffFunction, ReconnectingClient.singletonExecutor(), address, this.reconnectionListener, this.maxOutstandingRequests, this.eventLoopThreadFlushMaxBatchSize, binary, authenticator, this.executor.get(), this.connectionTimeoutMillis, this.charset, this.metrics, this.maxSetLength, this.eventLoopGroup, this.channelClass, this.sslEngineFactory);
    }
}

