/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerCertificates;
import com.spotify.docker.client.DockerCertificatesStore;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.auth.ConfigFileRegistryAuthSupplier;
import com.spotify.docker.client.auth.FixedRegistryAuthSupplier;
import com.spotify.docker.client.auth.MultiRegistryAuthSupplier;
import com.spotify.docker.client.auth.RegistryAuthSupplier;
import com.spotify.docker.client.auth.gcr.ContainerRegistryAuthSupplier;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.spotify.docker.client.messages.RegistryAuth;
import com.spotify.docker.client.messages.RegistryConfigs;
import com.spotify.docker.client.shaded.com.google.common.base.Optional;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

abstract class AbstractDockerMojo
extends AbstractMojo {
    @Component(role=MavenSession.class)
    protected MavenSession session;
    @Component(role=MojoExecution.class)
    protected MojoExecution execution;
    @Component
    private Settings settings;
    @Component(role=SecDispatcher.class, hint="mng-4384")
    private SecDispatcher secDispatcher;
    @Parameter(property="dockerHost")
    private String dockerHost;
    @Parameter(property="dockerCertPath")
    private String dockerCertPath;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="registryUrl")
    private String registryUrl;
    @Parameter(property="retryPushCount", defaultValue="5")
    private int retryPushCount;
    @Parameter(property="retryPushTimeout", defaultValue="10000")
    private int retryPushTimeout;
    @Parameter(property="skipDocker", defaultValue="false")
    private boolean skipDocker;
    @Parameter(property="skipDockerPush", defaultValue="false")
    private boolean skipDockerPush;

    AbstractDockerMojo() {
    }

    public int getRetryPushTimeout() {
        return this.retryPushTimeout;
    }

    public int getRetryPushCount() {
        return this.retryPushCount;
    }

    public boolean isSkipDocker() {
        return this.skipDocker;
    }

    public boolean isSkipDockerPush() {
        return this.skipDockerPush;
    }

    public void execute() throws MojoExecutionException {
        if (this.skipDocker) {
            this.getLog().info((CharSequence)"Skipping docker goal");
            return;
        }
        try (DockerClient client = this.buildDockerClient();){
            this.execute(client);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception caught", e);
        }
    }

    protected DefaultDockerClient.Builder getBuilder() throws DockerCertificateException {
        return DefaultDockerClient.fromEnv().readTimeoutMillis(0L);
    }

    protected DockerClient buildDockerClient() throws MojoExecutionException {
        DefaultDockerClient.Builder builder;
        try {
            Optional<DockerCertificatesStore> certs;
            builder = this.getBuilder();
            String dockerHost = this.rawDockerHost();
            if (!Strings.isNullOrEmpty((String)dockerHost)) {
                builder.uri(dockerHost);
            }
            if ((certs = this.dockerCertificates()).isPresent()) {
                builder.dockerCertificates((DockerCertificatesStore)certs.get());
            }
        }
        catch (DockerCertificateException ex) {
            throw new MojoExecutionException("Cannot build DockerClient due to certificate problem", (Exception)((Object)ex));
        }
        builder.registryAuthSupplier(this.authSupplier());
        return builder.build();
    }

    protected abstract void execute(DockerClient var1) throws Exception;

    protected String rawDockerHost() {
        return this.dockerHost;
    }

    protected Optional<DockerCertificatesStore> dockerCertificates() throws DockerCertificateException {
        if (!Strings.isNullOrEmpty((String)this.dockerCertPath)) {
            return DockerCertificates.builder().dockerCertPath(Paths.get(this.dockerCertPath, new String[0])).build();
        }
        return Optional.absent();
    }

    private String getEmail(Server server) {
        Xpp3Dom emailNode;
        String email = null;
        Xpp3Dom configuration = (Xpp3Dom)server.getConfiguration();
        if (configuration != null && (emailNode = configuration.getChild("email")) != null) {
            email = emailNode.getValue();
        }
        return email;
    }

    protected RegistryAuth registryAuth() throws MojoExecutionException {
        if (this.settings != null && this.serverId != null) {
            Server server = this.settings.getServer(this.serverId);
            if (server != null) {
                RegistryAuth.Builder registryAuthBuilder = RegistryAuth.builder();
                String username = server.getUsername();
                String password = server.getPassword();
                if (this.secDispatcher != null) {
                    try {
                        password = this.secDispatcher.decrypt(password);
                    }
                    catch (SecDispatcherException ex) {
                        throw new MojoExecutionException("Cannot decrypt password from settings", (Exception)((Object)ex));
                    }
                }
                String email = this.getEmail(server);
                if (!Strings.isNullOrEmpty((String)username)) {
                    registryAuthBuilder.username(username);
                }
                if (!Strings.isNullOrEmpty((String)email)) {
                    registryAuthBuilder.email(email);
                }
                if (!Strings.isNullOrEmpty((String)password)) {
                    registryAuthBuilder.password(password);
                }
                if (!Strings.isNullOrEmpty((String)this.registryUrl)) {
                    registryAuthBuilder.serverAddress(this.registryUrl);
                }
                return registryAuthBuilder.build();
            }
            this.getLog().warn((CharSequence)("No entry found in settings.xml for serverId=" + this.serverId + ", cannot configure authentication for that registry"));
        }
        return null;
    }

    private RegistryAuthSupplier authSupplier() throws MojoExecutionException {
        RegistryAuth registryAuth;
        ArrayList<Object> suppliers = new ArrayList<Object>();
        suppliers.add(new ConfigFileRegistryAuthSupplier());
        RegistryAuthSupplier googleRegistrySupplier = this.googleContainerRegistryAuthSupplier();
        if (googleRegistrySupplier != null) {
            suppliers.add(googleRegistrySupplier);
        }
        if ((registryAuth = this.registryAuth()) != null) {
            RegistryConfigs configsForBuild = RegistryConfigs.create((Map)ImmutableMap.of((Object)this.serverIdFor(registryAuth), (Object)registryAuth));
            suppliers.add(new FixedRegistryAuthSupplier(registryAuth, configsForBuild));
        }
        this.getLog().info((CharSequence)("Using authentication suppliers: " + Lists.transform(suppliers, (Function)new SupplierToClassNameFunction())));
        return new MultiRegistryAuthSupplier(suppliers);
    }

    private String serverIdFor(RegistryAuth registryAuth) {
        if (this.serverId != null) {
            return this.serverId;
        }
        if (registryAuth.serverAddress() != null) {
            return registryAuth.serverAddress();
        }
        return "index.docker.io";
    }

    private RegistryAuthSupplier googleContainerRegistryAuthSupplier() throws MojoExecutionException {
        File file;
        GoogleCredentials credentials = null;
        String googleCredentialsPath = System.getenv("DOCKER_GOOGLE_CREDENTIALS");
        if (googleCredentialsPath != null && (file = new File(googleCredentialsPath)).exists()) {
            try (FileInputStream inputStream = new FileInputStream(file);){
                credentials = GoogleCredentials.fromStream((InputStream)inputStream);
                this.getLog().info((CharSequence)("Using Google credentials from file: " + file.getAbsolutePath()));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Cannot load credentials referenced by DOCKER_GOOGLE_CREDENTIALS environment variable", (Exception)ex);
            }
        }
        if (credentials == null) {
            try {
                credentials = GoogleCredentials.getApplicationDefault();
                this.getLog().info((CharSequence)"Using Google application default credentials");
            }
            catch (IOException ex) {
                this.getLog().debug((CharSequence)"Failed to load Google application default credentials", (Throwable)ex);
            }
        }
        if (credentials == null) {
            return null;
        }
        return ContainerRegistryAuthSupplier.forCredentials((GoogleCredentials)credentials).build();
    }

    private static class SupplierToClassNameFunction
    implements Function<RegistryAuthSupplier, String> {
        private SupplierToClassNameFunction() {
        }

        @Nonnull
        public String apply(@Nonnull RegistryAuthSupplier input) {
            return input.getClass().getSimpleName();
        }
    }
}

