/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.collect.Queues;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class ApacheUnixSocket
extends Socket {
    private final UnixSocketChannel inner;
    private SocketAddress addr = null;
    private int lingerTime;
    private final Queue<SocketOptionSetter> optionsToSet = Queues.newArrayDeque();

    public ApacheUnixSocket() throws IOException {
        this.inner = UnixSocketChannel.open();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        if (endpoint instanceof UnixSocketAddress) {
            this.addr = endpoint;
            this.inner.connect((UnixSocketAddress)endpoint);
            this.setAllSocketOptions();
        }
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (endpoint instanceof UnixSocketAddress) {
            this.addr = endpoint;
            this.inner.connect((UnixSocketAddress)endpoint);
            this.setAllSocketOptions();
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.inner.isConnected()) {
            try {
                return InetAddress.getByName("localhost");
            }
            catch (UnknownHostException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.addr;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Channels.newInputStream(this.inner);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Channels.newOutputStream(this.inner);
    }

    private void setSocketOption(SocketOptionSetter optionSetter) throws SocketException {
        if (this.inner.isConnected()) {
            optionSetter.run();
        } else if (!this.optionsToSet.offer(optionSetter)) {
            throw new SocketException("Failed to queue option");
        }
    }

    private void setAllSocketOptions() throws SocketException {
        for (SocketOptionSetter setter : this.optionsToSet) {
            setter.run();
        }
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        if (on) {
            this.lingerTime = linger;
        }
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.lingerTime;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public synchronized void setSoTimeout(final int timeout) throws SocketException {
        this.setSocketOption(new SocketOptionSetter(){

            @Override
            public void run() throws SocketException {
                ApacheUnixSocket.this.inner.setSoTimeout(timeout);
            }
        });
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.inner.getSoTimeout();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public void setKeepAlive(final boolean on) throws SocketException {
        this.setSocketOption(new SocketOptionSetter(){

            @Override
            public void run() throws SocketException {
                ApacheUnixSocket.this.inner.setKeepAlive(on);
            }
        });
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.inner.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public int getTrafficClass() throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.lingerTime > 0) {
            boolean sleeping = true;
            while (sleeping) {
                try {
                    this.wait((long)this.lingerTime * 1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                sleeping = false;
            }
        }
        try {
            this.shutdownInput();
        }
        finally {
            try {
                this.shutdownOutput();
            }
            finally {
                this.inner.close();
            }
        }
    }

    @Override
    public void shutdownInput() throws IOException {
        this.inner.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.inner.shutdownOutput();
    }

    @Override
    public String toString() {
        if (this.addr != null) {
            return ((UnixSocketAddress)this.addr).toString();
        }
        return this.inner.toString();
    }

    @Override
    public boolean isConnected() {
        return this.inner.isConnected();
    }

    @Override
    public boolean isBound() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return !this.inner.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public boolean isOutputShutdown() {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException("Unimplemented");
    }

    static interface SocketOptionSetter {
        public void run() throws SocketException;
    }
}

