/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.model.internal;

import com.spotify.docker.client.shaded.javax.annotation.PreDestroy;
import com.spotify.docker.client.shaded.javax.inject.Inject;
import com.spotify.docker.client.shaded.javax.inject.Singleton;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.hk2.api.ServiceLocator;

@Singleton
public class ManagedObjectsFinalizer {
    @Inject
    private ServiceLocator serviceLocator;
    private final Set<Object> managedObjects = new HashSet<Object>();

    public void registerForPreDestroyCall(Object object) {
        this.managedObjects.add(object);
    }

    @PreDestroy
    public void preDestroy() {
        try {
            for (Object o : this.managedObjects) {
                this.serviceLocator.preDestroy(o);
            }
        }
        finally {
            this.managedObjects.clear();
        }
    }
}

