/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.spotify.dns.DnsException;
import com.spotify.dns.LookupFactory;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.lookup.LookupSession;

public class SimpleLookupFactory
implements LookupFactory {
    private final LookupSession session;
    private final Resolver resolver;

    @Deprecated
    public SimpleLookupFactory() {
        this(Lookup.getDefaultResolver());
    }

    public SimpleLookupFactory(Resolver resolver) {
        this(resolver, ForkJoinPool.commonPool());
    }

    public SimpleLookupFactory(Executor executor) {
        this(Lookup.getDefaultResolver(), executor);
    }

    public SimpleLookupFactory(Resolver resolver, Executor executor) {
        Objects.requireNonNull(executor);
        this.resolver = resolver;
        this.session = LookupSession.builder().resolver(resolver).executor(executor).build();
    }

    @Override
    public Lookup forName(String fqdn) {
        try {
            Lookup lookup = new Lookup(fqdn, 33, 1);
            if (this.resolver != null) {
                lookup.setResolver(this.resolver);
            }
            return lookup;
        }
        catch (TextParseException e) {
            throw new DnsException("unable to create lookup for name: " + fqdn, e);
        }
    }

    @Override
    public LookupSession sessionForName(String fqdn) {
        return this.session;
    }
}

