/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Throwables;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.LookupResult;
import com.spotify.dns.statistics.DnsReporter;
import com.spotify.dns.statistics.DnsTimingContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

class MeteredDnsSrvResolver
implements DnsSrvResolver {
    private final DnsSrvResolver delegate;
    private final DnsReporter reporter;

    MeteredDnsSrvResolver(DnsSrvResolver delegate, DnsReporter reporter) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.reporter = Objects.requireNonNull(reporter, "reporter");
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        List<LookupResult> result;
        DnsTimingContext resolveTimer = this.reporter.resolveTimer();
        try {
            result = this.delegate.resolve(fqdn);
        }
        catch (RuntimeException error) {
            this.reporter.reportFailure(error);
            throw error;
        }
        finally {
            resolveTimer.stop();
        }
        if (result.isEmpty()) {
            this.reporter.reportEmpty();
        }
        return result;
    }

    @Override
    public CompletionStage<List<LookupResult>> resolveAsync(String fqdn) {
        DnsTimingContext resolveTimer = this.reporter.resolveTimer();
        return this.delegate.resolveAsync(fqdn).handle((result, error) -> {
            resolveTimer.stop();
            if (error == null) {
                if (result.isEmpty()) {
                    this.reporter.reportEmpty();
                }
                return result;
            }
            this.reporter.reportFailure((Throwable)error);
            Throwables.throwIfUnchecked((Throwable)error);
            throw new RuntimeException((Throwable)error);
        });
    }
}

