/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.DnsSrvWatcher;
import com.spotify.dns.DnsSrvWatcherFactory;
import com.spotify.dns.ErrorHandler;
import com.spotify.dns.LookupResult;
import com.spotify.dns.PollingDnsSrvWatcher;
import com.spotify.dns.ServiceResolvingChangeNotifier;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class DnsSrvWatchers {
    public static DnsSrvWatcherBuilder<LookupResult> newBuilder(DnsSrvResolver resolver) {
        Objects.requireNonNull(resolver, "resolver");
        return new DnsSrvWatcherBuilder<LookupResult>(resolver, java.util.function.Function.identity());
    }

    public static <T> DnsSrvWatcherBuilder<T> newBuilder(DnsSrvResolver resolver, java.util.function.Function<LookupResult, T> resultTransformer) {
        Objects.requireNonNull(resolver, "resolver");
        Objects.requireNonNull(resultTransformer, "resultTransformer");
        return new DnsSrvWatcherBuilder(resolver, resultTransformer);
    }

    @Deprecated(since="3.2.0")
    public static <T> DnsSrvWatcherBuilder<T> newBuilder(DnsSrvResolver resolver, Function<LookupResult, T> resultTransformer) {
        Objects.requireNonNull(resolver, "resolver");
        Objects.requireNonNull(resultTransformer, "resultTransformer");
        return new DnsSrvWatcherBuilder(resolver, (java.util.function.Function)resultTransformer);
    }

    private DnsSrvWatchers() {
    }

    public static final class DnsSrvWatcherBuilder<T> {
        private final DnsSrvResolver resolver;
        private final java.util.function.Function<LookupResult, T> resultTransformer;
        private final boolean polling;
        private final long pollingInterval;
        private final TimeUnit pollingIntervalUnit;
        private final ErrorHandler errorHandler;
        private final DnsSrvWatcherFactory<T> dnsSrvWatcherFactory;
        private final ScheduledExecutorService scheduledExecutorService;

        private DnsSrvWatcherBuilder(DnsSrvResolver resolver, java.util.function.Function<LookupResult, T> resultTransformer) {
            this(resolver, resultTransformer, false, 0L, null, null, null, null);
        }

        private DnsSrvWatcherBuilder(DnsSrvResolver resolver, java.util.function.Function<LookupResult, T> resultTransformer, boolean polling, long pollingInterval, TimeUnit pollingIntervalUnit, ErrorHandler errorHandler, DnsSrvWatcherFactory<T> dnsSrvWatcherFactory, ScheduledExecutorService scheduledExecutorService) {
            this.resolver = resolver;
            this.resultTransformer = resultTransformer;
            this.polling = polling;
            this.pollingInterval = pollingInterval;
            this.pollingIntervalUnit = pollingIntervalUnit;
            this.errorHandler = errorHandler;
            this.dnsSrvWatcherFactory = dnsSrvWatcherFactory;
            this.scheduledExecutorService = scheduledExecutorService;
        }

        public DnsSrvWatcher<T> build() {
            DnsSrvWatcherFactory watcherFactory;
            Preconditions.checkState((boolean)(this.polling ^ this.dnsSrvWatcherFactory != null), (Object)"specify either polling or custom trigger");
            if (this.polling) {
                ScheduledExecutorService executor = this.scheduledExecutorService != null ? this.scheduledExecutorService : MoreExecutors.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("dns-lookup-%d").build()), (long)0L, (TimeUnit)TimeUnit.SECONDS);
                watcherFactory = cnf -> new PollingDnsSrvWatcher(cnf, executor, this.pollingInterval, this.pollingIntervalUnit);
            } else {
                watcherFactory = Objects.requireNonNull(this.dnsSrvWatcherFactory, "dnsSrvWatcherFactory");
            }
            ChangeNotifierFactory changeNotifierFactory = fqdn -> new ServiceResolvingChangeNotifier<T>(this.resolver, fqdn, this.resultTransformer, this.errorHandler);
            return watcherFactory.create(changeNotifierFactory);
        }

        public DnsSrvWatcherBuilder<T> polling(long pollingInterval, TimeUnit pollingIntervalUnit) {
            Preconditions.checkArgument((pollingInterval > 0L ? 1 : 0) != 0);
            Objects.requireNonNull(pollingIntervalUnit, "pollingIntervalUnit");
            return new DnsSrvWatcherBuilder<T>(this.resolver, this.resultTransformer, true, pollingInterval, pollingIntervalUnit, this.errorHandler, this.dnsSrvWatcherFactory, this.scheduledExecutorService);
        }

        public DnsSrvWatcherBuilder<T> usingExecutor(ScheduledExecutorService scheduledExecutorService) {
            return new DnsSrvWatcherBuilder<T>(this.resolver, this.resultTransformer, this.polling, this.pollingInterval, this.pollingIntervalUnit, this.errorHandler, this.dnsSrvWatcherFactory, scheduledExecutorService);
        }

        public DnsSrvWatcherBuilder<T> customTrigger(DnsSrvWatcherFactory<T> watcherFactory) {
            Objects.requireNonNull(watcherFactory, "watcherFactory");
            return new DnsSrvWatcherBuilder<T>(this.resolver, this.resultTransformer, true, this.pollingInterval, this.pollingIntervalUnit, this.errorHandler, watcherFactory, this.scheduledExecutorService);
        }

        public DnsSrvWatcherBuilder<T> withErrorHandler(ErrorHandler errorHandler) {
            Objects.requireNonNull(errorHandler, "errorHandler");
            return new DnsSrvWatcherBuilder<T>(this.resolver, this.resultTransformer, true, this.pollingInterval, this.pollingIntervalUnit, errorHandler, this.dnsSrvWatcherFactory, this.scheduledExecutorService);
        }
    }
}

