/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.spotify.dns.AbstractChangeNotifier;
import com.spotify.dns.ChangeNotifier;
import com.spotify.dns.ChangeNotifierFactory;
import com.spotify.dns.ChangeNotifiers;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

class DirectChangeNotifier<T>
extends AbstractChangeNotifier<T>
implements ChangeNotifierFactory.RunnableChangeNotifier<T> {
    private final Supplier<Set<T>> recordsSupplier;
    private volatile Set<T> records = ChangeNotifiers.initialEmptyDataInstance();
    private volatile boolean run = true;

    public DirectChangeNotifier(Supplier<Set<T>> recordsSupplier) {
        this.recordsSupplier = Objects.requireNonNull(recordsSupplier, "recordsSupplier");
    }

    @Override
    protected void closeImplementation() {
        this.run = false;
    }

    @Override
    public Set<T> current() {
        return this.records;
    }

    @Override
    public void run() {
        if (!this.run) {
            return;
        }
        Set<T> current = this.recordsSupplier.get();
        if (ChangeNotifiers.isNoLongerInitial(current, this.records) || !current.equals(this.records)) {
            ChangeNotifier.ChangeNotification<T> changeNotification = this.newChangeNotification(current, this.records);
            this.records = current;
            this.fireRecordsUpdated(changeNotification);
        }
    }
}

