/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dns;

import com.google.common.base.Preconditions;
import com.spotify.dns.DnsSrvResolver;
import com.spotify.dns.LookupResult;
import com.spotify.dns.statistics.DnsReporter;
import com.spotify.dns.statistics.DnsTimingContext;
import java.util.List;

class MeteredDnsSrvResolver
implements DnsSrvResolver {
    private final DnsSrvResolver delegate;
    private final DnsReporter reporter;

    MeteredDnsSrvResolver(DnsSrvResolver delegate, DnsReporter reporter) {
        this.delegate = (DnsSrvResolver)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.reporter = (DnsReporter)Preconditions.checkNotNull((Object)reporter, (Object)"reporter");
    }

    @Override
    public List<LookupResult> resolve(String fqdn) {
        List<LookupResult> result;
        DnsTimingContext resolveTimer = this.reporter.resolveTimer();
        try {
            result = this.delegate.resolve(fqdn);
        }
        catch (RuntimeException error) {
            this.reporter.reportFailure(error);
            throw error;
        }
        finally {
            resolveTimer.stop();
        }
        if (result.isEmpty()) {
            this.reporter.reportEmpty();
        }
        return result;
    }
}

