/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.zoltar.examples.metrics;

import com.codahale.metrics.Counter;
import com.google.auto.value.AutoValue;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.spotify.metrics.core.MetricId;
import com.spotify.metrics.core.SemanticMetricRegistry;
import com.spotify.zoltar.FeatureExtractFns;
import com.spotify.zoltar.FeatureExtractor;
import com.spotify.zoltar.Model;
import com.spotify.zoltar.ModelLoader;
import com.spotify.zoltar.PredictFns;
import com.spotify.zoltar.Prediction;
import com.spotify.zoltar.Predictor;
import com.spotify.zoltar.PredictorBuilder;
import com.spotify.zoltar.Predictors;
import com.spotify.zoltar.Vector;
import com.spotify.zoltar.examples.metrics.AutoValue_CustomMetricsExample_CustomMetrics;
import com.spotify.zoltar.examples.metrics.AutoValue_CustomMetricsExample_CustomPredictorMetrics;
import com.spotify.zoltar.examples.metrics.AutoValue_CustomMetricsExample_NegativeExtractMetrics;
import com.spotify.zoltar.examples.metrics.AutoValue_CustomMetricsExample_NegativePredictMetrics;
import com.spotify.zoltar.examples.metrics.DummyModel;
import com.spotify.zoltar.loaders.Preloader;
import com.spotify.zoltar.metrics.FeatureExtractorMetrics;
import com.spotify.zoltar.metrics.Instrumentations;
import com.spotify.zoltar.metrics.InstrumentedPredictorBuilder;
import com.spotify.zoltar.metrics.PredictFnMetrics;
import com.spotify.zoltar.metrics.PredictMetrics;
import com.spotify.zoltar.metrics.PredictorMetrics;
import com.spotify.zoltar.metrics.VectorMetrics;
import com.spotify.zoltar.metrics.semantic.SemanticPredictorMetrics;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;

class CustomMetricsExample
implements Predictor<Integer, Float> {
    private PredictorBuilder<DummyModel, Integer, Float, Float> predictorBuilder;

    CustomMetricsExample(SemanticMetricRegistry metricRegistry, MetricId metricId) {
        ModelLoader modelLoader = ModelLoader.lift(DummyModel::new).with(Preloader.preload((Duration)Duration.ofMinutes(1L)));
        FeatureExtractFns.SingleExtractFn extractFn = input -> Float.valueOf((float)input.intValue() / 10.0f);
        PredictFns.PredictFn predictFn = (model, vectors) -> vectors.stream().map(vector -> Prediction.create((Object)vector.input(), (Object)Float.valueOf(((Float)vector.value()).floatValue() * 2.0f))).collect(Collectors.toList());
        FeatureExtractor featureExtractor = FeatureExtractor.create((FeatureExtractFns.ExtractFn)extractFn);
        SemanticPredictorMetrics predictorMetrics = SemanticPredictorMetrics.create((SemanticMetricRegistry)metricRegistry, (MetricId)metricId);
        CustomPredictorMetrics customMetrics = CustomPredictorMetrics.create(metricRegistry, metricId);
        this.predictorBuilder = ((InstrumentedPredictorBuilder)Predictors.newBuilder((ModelLoader)modelLoader, (FeatureExtractor)featureExtractor, (PredictFns.PredictFn)predictFn).with(Instrumentations.predictor((PredictorMetrics)predictorMetrics))).with(Instrumentations.predictor((PredictorMetrics)customMetrics));
    }

    public CompletionStage<List<Prediction<Integer, Float>>> predict(ScheduledExecutorService scheduler, Duration timeout, Integer ... input) {
        return this.predictorBuilder.predictor().predict(scheduler, timeout, (Object[])input);
    }

    @AutoValue
    static abstract class NegativeExtractMetrics
    implements VectorMetrics<Integer, Float> {
        NegativeExtractMetrics() {
        }

        abstract Counter negativeExtractCount();

        static NegativeExtractMetrics create(Counter negativeCount) {
            return new AutoValue_CustomMetricsExample_NegativeExtractMetrics(negativeCount);
        }

        public void extraction(List<Vector<Integer, Float>> vectors) {
            this.negativeExtractCount().inc(vectors.stream().filter(v -> ((Float)v.value()).floatValue() < 0.0f).count());
        }
    }

    @AutoValue
    static abstract class NegativePredictMetrics
    implements PredictMetrics<Integer, Float> {
        NegativePredictMetrics() {
        }

        abstract Counter negativePredictCount();

        static NegativePredictMetrics create(Counter negativeCount) {
            return new AutoValue_CustomMetricsExample_NegativePredictMetrics(negativeCount);
        }

        public void prediction(List<Prediction<Integer, Float>> predictions) {
            this.negativePredictCount().inc(predictions.stream().filter(x -> ((Float)x.value()).floatValue() < 0.0f).count());
        }
    }

    @AutoValue
    static abstract class CustomPredictorMetrics
    implements PredictorMetrics<Integer, Float, Float> {
        CustomPredictorMetrics() {
        }

        abstract LoadingCache<Model.Id, CustomMetrics> metricsCache();

        static CustomPredictorMetrics create(final SemanticMetricRegistry registry, final MetricId metricId) {
            LoadingCache metersCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Model.Id, CustomMetrics>(){

                public CustomMetrics load(Model.Id id) {
                    return CustomMetrics.create(registry, metricId.tagged(new String[]{"model", id.value()}));
                }
            });
            return new AutoValue_CustomMetricsExample_CustomPredictorMetrics((LoadingCache<Model.Id, CustomMetrics>)metersCache);
        }

        public PredictFnMetrics<Integer, Float> predictFnMetrics() {
            return id -> {
                CustomMetrics metrics = (CustomMetrics)this.metricsCache().getUnchecked(id);
                Counter negativePredictCounter = metrics.negativePredictCount();
                return NegativePredictMetrics.create(negativePredictCounter);
            };
        }

        public FeatureExtractorMetrics<Integer, Float> featureExtractorMetrics() {
            return id -> {
                CustomMetrics metrics = (CustomMetrics)this.metricsCache().getUnchecked(id);
                Counter negativeExtractCounter = metrics.negativeExtractCount();
                return NegativeExtractMetrics.create(negativeExtractCounter);
            };
        }
    }

    @AutoValue
    static abstract class CustomMetrics {
        CustomMetrics() {
        }

        abstract Counter negativePredictCount();

        abstract Counter negativeExtractCount();

        static CustomMetrics create(SemanticMetricRegistry registry, MetricId metricId) {
            MetricId predictCountId = metricId.tagged(new String[]{"what", "negativePredictCount"});
            MetricId extractCountId = metricId.tagged(new String[]{"what", "negativeExtractCount"});
            Counter negativePredictCount = registry.counter(predictCountId);
            Counter negativeExtractCount = registry.counter(extractCountId);
            return new AutoValue_CustomMetricsExample_CustomMetrics(negativePredictCount, negativeExtractCount);
        }
    }
}

