/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.annoy;

import com.spotify.annoy.AnnoyIndex;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class ANNIndex
implements AnnoyIndex {
    private int dimension;
    private int minLeafSize;
    private int nodeSize;
    private ArrayList<Integer> roots;
    private MappedByteBuffer annBuf;
    private final int kNodeHeaderSize = 12;
    private final int kFloatSize = 4;
    private static float[] zeros = new float[40];

    public ANNIndex(int dimension, String filename) throws IOException {
        this.init(dimension);
        this.load(filename);
    }

    private void init(int dimension) {
        this.dimension = dimension;
        this.roots = new ArrayList();
        this.minLeafSize = dimension + 2;
        this.nodeSize = 12 + 4 * dimension;
    }

    private void load(String filename) throws IOException {
        RandomAccessFile memoryMappedFile = new RandomAccessFile(filename, "r");
        int fileSize = (int)memoryMappedFile.length();
        System.err.printf("%s: %d bytes\n", filename, fileSize);
        this.annBuf = memoryMappedFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
        this.annBuf.order(ByteOrder.LITTLE_ENDIAN);
        int m = -1;
        for (int i = fileSize - this.nodeSize; i >= 0; i -= this.nodeSize) {
            int k = this.annBuf.getInt(i);
            if (m != -1 && k != m) break;
            this.roots.add(i);
            m = k;
        }
        System.err.printf("%s: found %d roots with degree %d\n", filename, this.roots.size(), m);
    }

    @Override
    public final void getNodeVector(int node, float[] v) {
        for (int i = 0; i < this.dimension; ++i) {
            v[i] = this.annBuf.getFloat(i * 4 + node + 12);
        }
    }

    @Override
    public final void getItemVector(int item, float[] v) {
        this.getNodeVector(item * this.nodeSize, v);
    }

    public static double norm(float[] u) {
        float n = 0.0f;
        for (float x : u) {
            n += x * x;
        }
        return Math.sqrt(n);
    }

    public static float cosineMargin(float[] u, float[] v) {
        double d = 0.0;
        double un = ANNIndex.norm(u);
        double vn = ANNIndex.norm(v);
        for (int i = 0; i < u.length; ++i) {
            d += (double)(u[i] * v[i]);
        }
        return (float)(d / (un * vn));
    }

    public static float cosineDist(float[] u, float[] v) {
        return 1.0f - ANNIndex.cosineMargin(u, v);
    }

    @Override
    public final List<Integer> getNearest(float[] queryVector, int nResults) {
        PriorityQueue<PQEntry> pq = new PriorityQueue<PQEntry>(this.roots.size() * 4);
        float kMaxPriority = 1.0E30f;
        float[] v = new float[this.dimension];
        for (int r : this.roots) {
            pq.add(new PQEntry(1.0E30f, r));
        }
        HashSet<Integer> nearestNeighbors = new HashSet<Integer>();
        while (nearestNeighbors.size() < this.roots.size() * nResults && !pq.isEmpty()) {
            PQEntry top = (PQEntry)pq.poll();
            int n = top.node;
            int nDescendants = this.annBuf.getInt(n);
            this.getNodeVector(n, v);
            if (Arrays.equals(v, zeros)) continue;
            if (nDescendants == 1) {
                nearestNeighbors.add(n / this.nodeSize);
                continue;
            }
            if (nDescendants <= this.minLeafSize) {
                for (int i = 0; i < nDescendants; ++i) {
                    int j = this.annBuf.getInt(4 + n + i * 4);
                    nearestNeighbors.add(j);
                }
                continue;
            }
            float margin = ANNIndex.cosineMargin(v, queryVector);
            int lChild = this.nodeSize * this.annBuf.getInt(n + 4);
            int rChild = this.nodeSize * this.annBuf.getInt(n + 8);
            pq.add(new PQEntry(-margin, lChild));
            pq.add(new PQEntry(margin, rChild));
        }
        ArrayList<PQEntry> sortedNNs = new ArrayList<PQEntry>();
        int i = 0;
        Iterator i$ = nearestNeighbors.iterator();
        while (i$.hasNext()) {
            int nn = (Integer)i$.next();
            this.getItemVector(nn, v);
            if (Arrays.equals(v, zeros)) continue;
            sortedNNs.add(new PQEntry(ANNIndex.cosineMargin(v, queryVector), nn));
        }
        Collections.sort(sortedNNs);
        ArrayList<Integer> result = new ArrayList<Integer>(nResults);
        for (i = 0; i < nResults && i < sortedNNs.size(); ++i) {
            result.add(((PQEntry)sortedNNs.get(i)).node);
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        ANNIndex annIndex = new ANNIndex(Integer.parseInt(args[0]), args[1]);
        float[] u = new float[annIndex.dimension];
        float[] v = new float[annIndex.dimension];
        int queryItem = Integer.parseInt(args[2]);
        annIndex.getItemVector(queryItem, u);
        System.out.printf("vector[%d]: ", queryItem);
        for (float x : u) {
            System.out.printf("%2.2f ", Float.valueOf(x));
        }
        System.out.printf("\n", new Object[0]);
        List<Integer> nearestNeighbors = annIndex.getNearest(u, 10);
        for (int nn : nearestNeighbors) {
            annIndex.getItemVector(nn, v);
            System.out.printf("%d %d %f\n", queryItem, nn, Float.valueOf(ANNIndex.cosineMargin(u, v)));
        }
    }

    private class PQEntry
    implements Comparable<PQEntry> {
        private float margin;
        private int node;

        PQEntry(float margin, int node) {
            this.margin = margin;
            this.node = node;
        }

        @Override
        public int compareTo(PQEntry o) {
            return Float.compare(o.margin, this.margin);
        }
    }
}

