/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.browser;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.browser.customtabs.CustomTabsCallback;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import com.spotify.sdk.android.auth.AuthorizationHandler;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.browser.CustomTabsSupportChecker;

public class BrowserAuthHandler
implements AuthorizationHandler {
    private static final String TAG = BrowserAuthHandler.class.getSimpleName();
    private CustomTabsSession mTabsSession;
    private CustomTabsServiceConnection mTabConnection;
    private boolean mIsAuthInProgress = false;
    private Context mContext;
    private Uri mUri;

    @Override
    public boolean start(Activity contextActivity, final AuthorizationRequest request) {
        boolean shouldLaunchCustomTab;
        Log.d((String)TAG, (String)"start");
        this.mContext = contextActivity;
        this.mUri = request.toUri();
        String packageSupportingCustomTabs = CustomTabsSupportChecker.getPackageSupportingCustomTabs(this.mContext, request);
        boolean bl = shouldLaunchCustomTab = !TextUtils.isEmpty((CharSequence)packageSupportingCustomTabs);
        if (this.internetPermissionNotGranted(this.mContext)) {
            Log.e((String)TAG, (String)"Missing INTERNET permission");
        }
        if (shouldLaunchCustomTab) {
            Log.d((String)TAG, (String)("Launching auth in a Custom Tab using package:" + packageSupportingCustomTabs));
            this.mTabConnection = new CustomTabsServiceConnection(){

                public void onCustomTabsServiceConnected(@NonNull ComponentName name, @NonNull CustomTabsClient client) {
                    client.warmup(0L);
                    BrowserAuthHandler.this.mTabsSession = client.newSession(new CustomTabsCallback());
                    if (BrowserAuthHandler.this.mTabsSession != null) {
                        CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setSession(BrowserAuthHandler.this.mTabsSession).build();
                        customTabsIntent.launchUrl(BrowserAuthHandler.this.mContext, request.toUri());
                        BrowserAuthHandler.this.mIsAuthInProgress = true;
                    } else {
                        BrowserAuthHandler.this.unbindCustomTabsService();
                        Log.i((String)TAG, (String)"Auth using CustomTabs aborted, reason: CustomTabsSession is null.");
                        BrowserAuthHandler.this.launchAuthInBrowserFallback();
                    }
                }

                public void onServiceDisconnected(ComponentName name) {
                    Log.i((String)TAG, (String)"Auth using CustomTabs aborted, reason: CustomTabsService disconnected.");
                    BrowserAuthHandler.this.mTabsSession = null;
                    BrowserAuthHandler.this.mTabConnection = null;
                }
            };
            CustomTabsClient.bindCustomTabsService((Context)this.mContext, (String)packageSupportingCustomTabs, (CustomTabsServiceConnection)this.mTabConnection);
        } else {
            Log.d((String)TAG, (String)"Launching auth inside a web browser");
            this.launchAuthInBrowserFallback();
        }
        return true;
    }

    @Override
    public void stop() {
        Log.d((String)TAG, (String)"stop");
        this.unbindCustomTabsService();
        this.mContext = null;
        this.mIsAuthInProgress = false;
    }

    @Override
    public void setOnCompleteListener(@Nullable AuthorizationHandler.OnCompleteListener listener) {
    }

    @Override
    public boolean isAuthInProgress() {
        return this.mIsAuthInProgress;
    }

    private void launchAuthInBrowserFallback() {
        if (this.internetPermissionNotGranted(this.mContext)) {
            Log.e((String)TAG, (String)"Missing INTERNET permission");
        }
        this.mContext.startActivity(new Intent("android.intent.action.VIEW", this.mUri));
        this.mIsAuthInProgress = true;
    }

    private boolean internetPermissionNotGranted(Context context) {
        String packageName;
        PackageManager pm = context.getPackageManager();
        return pm.checkPermission("android.permission.INTERNET", packageName = context.getPackageName()) != 0;
    }

    public void unbindCustomTabsService() {
        if (this.mTabConnection == null) {
            return;
        }
        this.mContext.unbindService((ServiceConnection)this.mTabConnection);
        this.mTabsSession = null;
        this.mTabConnection = null;
    }
}

