/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.sdk.android.auth.webview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.spotify.sdk.android.auth.AuthorizationHandler;
import com.spotify.sdk.android.auth.AuthorizationRequest;
import com.spotify.sdk.android.auth.AuthorizationResponse;
import com.spotify.sdk.android.auth.R;
import com.spotify.sdk.android.auth.webview.WebViewUtils;
import java.util.Locale;

public class LoginDialog
extends Dialog {
    private static final String TAG = LoginDialog.class.getName();
    private static final String WEBVIEW_URIS = "^(.+\\.facebook\\.com)|(accounts\\.spotify\\.com)$";
    private static final int DEFAULT_THEME = 0x1030010;
    private static final int MAX_WIDTH_DP = 400;
    private static final int MAX_HEIGHT_DP = 640;
    private final Uri mUri;
    private AuthorizationHandler.OnCompleteListener mListener;
    private ProgressDialog mProgressDialog;
    private boolean mAttached;
    private boolean mResultDelivered;

    public LoginDialog(Activity contextActivity, AuthorizationRequest request) {
        super((Context)contextActivity, 0x1030010);
        this.mUri = request.toUri();
    }

    public LoginDialog(Activity contextActivity, int theme, AuthorizationRequest request) {
        super((Context)contextActivity, theme);
        this.mUri = request.toUri();
    }

    public void setOnCompleteListener(AuthorizationHandler.OnCompleteListener listener) {
        this.mListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mResultDelivered = false;
        this.mProgressDialog = new ProgressDialog(this.getContext());
        this.mProgressDialog.setMessage((CharSequence)this.getContext().getString(R.string.com_spotify_sdk_login_progress));
        this.mProgressDialog.requestWindowFeature(1);
        this.mProgressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialogInterface) {
                LoginDialog.this.dismiss();
            }
        });
        this.requestWindowFeature(1);
        this.getWindow().setSoftInputMode(16);
        this.getWindow().setBackgroundDrawableResource(17301673);
        this.setContentView(R.layout.com_spotify_sdk_login_dialog);
        this.setLayoutSize();
        this.createWebView(this.mUri);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void createWebView(Uri uri) {
        if (!this.internetPermissionGranted()) {
            Log.e((String)TAG, (String)"Missing INTERNET permission");
        }
        final WebView webView = (WebView)this.findViewById(R.id.com_spotify_sdk_login_webview);
        final LinearLayout mWebViewContainer = (LinearLayout)this.findViewById(R.id.com_spotify_sdk_login_webview_container);
        final String redirectUri = uri.getQueryParameter("redirect_uri");
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setSaveFormData(false);
        webSettings.setSavePassword(false);
        webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                if (LoginDialog.this.mAttached) {
                    LoginDialog.this.mProgressDialog.dismiss();
                }
                webView.setVisibility(0);
                mWebViewContainer.setVisibility(0);
                super.onPageFinished(view, url);
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
                if (LoginDialog.this.mAttached) {
                    LoginDialog.this.mProgressDialog.show();
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                String caseSafeRequestRedirectUri = redirectUri.toLowerCase(Locale.ENGLISH);
                String caseSafeResponseRedirectUri = url.toLowerCase(Locale.ENGLISH);
                Uri responseUri = Uri.parse((String)url);
                if (caseSafeResponseRedirectUri.startsWith(caseSafeRequestRedirectUri)) {
                    LoginDialog.this.sendComplete(responseUri);
                    return true;
                }
                if (responseUri.getAuthority().matches(LoginDialog.WEBVIEW_URIS)) {
                    return false;
                }
                String errorMessage = String.format("Can't redirect due to mismatch. \nRequest redirect-uri: %s\nResponse redirect-uri: %s", redirectUri, responseUri);
                Log.e((String)TAG, (String)errorMessage);
                LoginDialog.this.sendError(new RuntimeException(errorMessage));
                return true;
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                super.onReceivedError(view, errorCode, description, failingUrl);
                LoginDialog.this.sendError(new Error(String.format("%s, code: %s, failing url: %s", description, errorCode, failingUrl)));
            }
        });
        webView.loadUrl(uri.toString());
    }

    private void sendComplete(Uri responseUri) {
        this.mResultDelivered = true;
        if (this.mListener != null) {
            this.mListener.onComplete(AuthorizationResponse.fromUri(responseUri));
        }
        this.close();
    }

    private void sendError(Throwable error) {
        this.mResultDelivered = true;
        if (this.mListener != null) {
            this.mListener.onError(error);
        }
        this.close();
    }

    public void onAttachedToWindow() {
        this.mAttached = true;
        super.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        this.mAttached = false;
        super.onDetachedFromWindow();
    }

    protected void onStop() {
        if (!this.mResultDelivered && this.mListener != null) {
            this.mListener.onCancel();
        }
        this.mResultDelivered = true;
        this.mProgressDialog.dismiss();
        super.onStop();
    }

    public void close() {
        if (this.mAttached) {
            this.dismiss();
        }
    }

    private boolean internetPermissionGranted() {
        String packageName;
        PackageManager pm = this.getContext().getPackageManager();
        return pm.checkPermission("android.permission.INTERNET", packageName = this.getContext().getPackageName()) == 0;
    }

    private void setLayoutSize() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        display.getMetrics(metrics);
        int dialogWidth = -1;
        int dialogHeight = -1;
        if ((float)metrics.widthPixels / metrics.density > 400.0f) {
            dialogWidth = (int)(400.0f * metrics.density);
        }
        if ((float)metrics.heightPixels / metrics.density > 640.0f) {
            dialogHeight = (int)(640.0f * metrics.density);
        }
        LinearLayout layout2 = (LinearLayout)this.findViewById(R.id.com_spotify_sdk_login_webview_container);
        layout2.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(dialogWidth, dialogHeight, 17));
    }

    public static void clearCookies(Context context) {
        WebViewUtils.clearFacebookCookies(context);
        WebViewUtils.clearCookiesForDomain(context, "spotify.com");
        WebViewUtils.clearCookiesForDomain(context, ".spotify.com");
        WebViewUtils.clearCookiesForDomain(context, "https://spotify.com");
        WebViewUtils.clearCookiesForDomain(context, "https://.spotify.com");
    }
}

