/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import java.util.Objects;

public final class SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    private static final AttributeKey<String> DB_SQL_TABLE = AttributeKey.stringKey("db.sql.table");
    final SqlClientAttributesGetter<REQUEST, RESPONSE> getter;
    AttributeKey<String> oldSemconvTableAttribute = DB_SQL_TABLE;
    boolean statementSanitizationEnabled = true;
    boolean captureQueryParameters = false;

    SqlClientAttributesExtractorBuilder(SqlClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setTableAttribute(AttributeKey<String> oldSemconvTableAttribute) {
        this.oldSemconvTableAttribute = Objects.requireNonNull(oldSemconvTableAttribute);
        return this;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setStatementSanitizationEnabled(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        return this;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCaptureQueryParameters(boolean captureQueryParameters) {
        this.captureQueryParameters = captureQueryParameters;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new SqlClientAttributesExtractor<REQUEST, RESPONSE>(this.getter, this.oldSemconvTableAttribute, this.statementSanitizationEnabled, this.captureQueryParameters);
    }
}

