/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.EventBodySerializer;
import com.splunk.logging.EventHeaderSerializer;
import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="SplunkHttp", category="Core", elementType="appender", printObject=true)
public final class HttpEventCollectorLog4jAppender
extends AbstractAppender {
    private HttpEventCollectorSender sender = null;
    private final boolean includeLoggerName;
    private final boolean includeThreadName;
    private final boolean includeMDC;
    private final boolean includeException;
    private final boolean includeMarker;

    private HttpEventCollectorLog4jAppender(String name, String url, String token, String channel, String type, String source, String sourcetype, String messageFormat, String host, String index, Filter filter, Layout<? extends Serializable> layout, boolean includeLoggerName, boolean includeThreadName, boolean includeMDC, boolean includeException, boolean includeMarker, boolean ignoreExceptions, long batchInterval, long batchCount, long batchSize, long retriesOnError, String sendMode, String middleware, String disableCertificateValidation, String eventBodySerializer, String eventHeaderSerializer, HttpEventCollectorSender.TimeoutSettings timeoutSettings) {
        super(name, filter, layout, ignoreExceptions, Property.EMPTY_ARRAY);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("host", host != null ? host : "");
        metadata.put("index", index != null ? index : "");
        metadata.put("source", source != null ? source : "");
        metadata.put("sourcetype", sourcetype != null ? sourcetype : "");
        metadata.put("messageFormat", messageFormat != null ? messageFormat : "");
        this.sender = new HttpEventCollectorSender(url, token, channel, type, batchInterval, batchCount, batchSize, sendMode, metadata, timeoutSettings);
        if (middleware != null && !middleware.isEmpty()) {
            try {
                this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)Class.forName(middleware).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (eventBodySerializer != null && !eventBodySerializer.isEmpty()) {
            try {
                this.sender.setEventBodySerializer((EventBodySerializer)Class.forName(eventBodySerializer).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (eventHeaderSerializer != null && !eventHeaderSerializer.isEmpty()) {
            try {
                this.sender.setEventHeaderSerializer((EventHeaderSerializer)Class.forName(eventHeaderSerializer).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (retriesOnError > 0L) {
            this.sender.addMiddleware(new HttpEventCollectorResendMiddleware(retriesOnError));
        }
        if (disableCertificateValidation != null && disableCertificateValidation.equalsIgnoreCase("true")) {
            this.sender.disableCertificateValidation();
        }
        this.includeLoggerName = includeLoggerName;
        this.includeThreadName = includeThreadName;
        this.includeMDC = includeMDC;
        this.includeException = includeException;
        this.includeMarker = includeMarker;
    }

    @PluginFactory
    public static HttpEventCollectorLog4jAppender createAppender(@PluginAttribute(value="url") String url, @PluginAttribute(value="token") String token, @PluginAttribute(value="channel") String channel, @PluginAttribute(value="type") String type, @PluginAttribute(value="name") String name, @PluginAttribute(value="source") String source, @PluginAttribute(value="sourcetype") String sourcetype, @PluginAttribute(value="messageFormat") String messageFormat, @PluginAttribute(value="host") String host, @PluginAttribute(value="index") String index, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) String ignoreExceptions, @PluginAttribute(value="batch_size_bytes") String batchSize, @PluginAttribute(value="batch_size_count") String batchCount, @PluginAttribute(value="batch_interval") String batchInterval, @PluginAttribute(value="retries_on_error") String retriesOnError, @PluginAttribute(value="send_mode") String sendMode, @PluginAttribute(value="middleware") String middleware, @PluginAttribute(value="disableCertificateValidation") String disableCertificateValidation, @PluginAttribute(value="eventBodySerializer") String eventBodySerializer, @PluginAttribute(value="eventHeaderSerializer") String eventHeaderSerializer, @PluginAttribute(value="includeLoggerName", defaultBoolean=true) boolean includeLoggerName, @PluginAttribute(value="includeThreadName", defaultBoolean=true) boolean includeThreadName, @PluginAttribute(value="includeMDC", defaultBoolean=true) boolean includeMDC, @PluginAttribute(value="includeException", defaultBoolean=true) boolean includeException, @PluginAttribute(value="includeMarker", defaultBoolean=true) boolean includeMarker, @PluginAttribute(value="connect_timeout", defaultLong=30000L) long connectTimeout, @PluginAttribute(value="call_timeout", defaultLong=0L) long callTimeout, @PluginAttribute(value="read_timeout", defaultLong=0L) long readTimeout, @PluginAttribute(value="write_timeout", defaultLong=0L) long writeTimeout, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for HttpEventCollectorLog4jAppender");
            return null;
        }
        if (url == null) {
            LOGGER.error("No Splunk URL provided for HttpEventCollectorLog4jAppender");
            return null;
        }
        if (token == null) {
            LOGGER.error("No token provided for HttpEventCollectorLog4jAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.newBuilder().withPattern("%m").withCharset(StandardCharsets.UTF_8).withAlwaysWriteExceptions(true).withNoConsoleNoAnsi(false).build();
        }
        boolean ignoreExceptionsBool = Boolean.getBoolean(ignoreExceptions);
        return new HttpEventCollectorLog4jAppender(name, url, token, channel, type, source, sourcetype, messageFormat, host, index, filter, (Layout<? extends Serializable>)layout, includeLoggerName, includeThreadName, includeMDC, includeException, includeMarker, ignoreExceptionsBool, HttpEventCollectorLog4jAppender.parseInt((String)batchInterval, (int)10000), HttpEventCollectorLog4jAppender.parseInt((String)batchCount, (int)10), HttpEventCollectorLog4jAppender.parseInt((String)batchSize, (int)10240), HttpEventCollectorLog4jAppender.parseInt((String)retriesOnError, (int)0), sendMode, middleware, disableCertificateValidation, eventBodySerializer, eventHeaderSerializer, new HttpEventCollectorSender.TimeoutSettings(connectTimeout, callTimeout, readTimeout, writeTimeout));
    }

    public void append(LogEvent event) {
        this.sender.send(event.getLevel().toString(), this.getLayout().toSerializable(event).toString(), this.includeLoggerName ? event.getLoggerName() : null, this.includeThreadName ? event.getThreadName() : null, this.includeMDC ? event.getContextData().toMap() : null, !this.includeException || event.getThrown() == null ? null : event.getThrown().getMessage(), (Serializable)(this.includeMarker ? event.getMarker() : null));
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.sender.close();
        return super.stop(timeout, timeUnit);
    }
}

