/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.splunk.logging.EventBodySerializer;
import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorEventInfo;
import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.MessageFormat;
import com.splunk.logging.serialization.EventInfoTypeAdapter;
import com.splunk.logging.serialization.HecJsonSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpEventCollectorSender
extends TimerTask
implements HttpEventCollectorMiddleware.IHttpSender {
    private static final String SPLUNKREQUESTCHANNELTag = "X-Splunk-Request-Channel";
    private static final String AuthorizationHeaderTag = "Authorization";
    private static final String AuthorizationHeaderScheme = "Splunk %s";
    private static final String HttpEventCollectorUriPath = "/services/collector/event/1.0";
    private static final String HttpRawCollectorUriPath = "/services/collector/raw";
    private static final String HttpContentType = "application/json; profile=urn:splunk:event:1.0; charset=utf-8";
    private static final String SendModeSequential = "sequential";
    private static final String SendModeSParallel = "parallel";
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(HttpEventCollectorEventInfo.class, (Object)new EventInfoTypeAdapter()).create();
    private final HecJsonSerializer serializer;
    public static final int DefaultBatchInterval = 10000;
    public static final int DefaultBatchSize = 10240;
    public static final int DefaultBatchCount = 10;
    private String url;
    private String token;
    private String channel;
    private String type;
    private long maxEventsBatchCount;
    private long maxEventsBatchSize;
    private Timer timer;
    private List<HttpEventCollectorEventInfo> eventsBatch = new LinkedList<HttpEventCollectorEventInfo>();
    private long eventsBatchSize = 0L;
    private static OkHttpClient httpClient = null;
    private boolean disableCertificateValidation = false;
    private SendMode sendMode = SendMode.Sequential;
    private HttpEventCollectorMiddleware middleware = new HttpEventCollectorMiddleware();
    private final MessageFormat messageFormat;

    public HttpEventCollectorSender(String Url, String token, String channel, String type, long delay, long maxEventsBatchCount, long maxEventsBatchSize, String sendModeStr, Map<String, String> metadata) {
        this.url = Url + HttpEventCollectorUriPath;
        this.token = token;
        this.channel = channel;
        this.type = type;
        if ("Raw".equalsIgnoreCase(type)) {
            this.url = Url + HttpRawCollectorUriPath;
        }
        if (maxEventsBatchCount == 0L && maxEventsBatchSize > 0L) {
            maxEventsBatchCount = Long.MAX_VALUE;
        } else if (maxEventsBatchSize == 0L && maxEventsBatchCount > 0L) {
            maxEventsBatchSize = Long.MAX_VALUE;
        }
        this.maxEventsBatchCount = maxEventsBatchCount;
        this.maxEventsBatchSize = maxEventsBatchSize;
        this.serializer = new HecJsonSerializer(metadata);
        String format = metadata.get("messageFormat");
        this.messageFormat = MessageFormat.fromFormat(format);
        if (sendModeStr != null) {
            if (sendModeStr.equals(SendModeSequential)) {
                this.sendMode = SendMode.Sequential;
            } else if (sendModeStr.equals(SendModeSParallel)) {
                this.sendMode = SendMode.Parallel;
            } else {
                throw new IllegalArgumentException("Unknown send mode: " + sendModeStr);
            }
        }
        if (delay > 0L) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)this, delay, delay);
        }
    }

    public void addMiddleware(HttpEventCollectorMiddleware.HttpSenderMiddleware middleware) {
        this.middleware.add(middleware);
    }

    public synchronized void send(String severity, String message, String logger_name, String thread_name, Map<String, String> properties, String exception_message, Serializable marker) {
        HttpEventCollectorEventInfo eventInfo = new HttpEventCollectorEventInfo(severity, message, logger_name, thread_name, properties, exception_message, marker);
        this.eventsBatch.add(eventInfo);
        this.eventsBatchSize += (long)(severity.length() + message.length());
        if ((long)this.eventsBatch.size() >= this.maxEventsBatchCount || this.eventsBatchSize > this.maxEventsBatchSize) {
            this.flush();
        }
    }

    public synchronized void send(String message) {
        this.send("", message, "", "", null, null, (Serializable)((Object)""));
    }

    public synchronized void flush() {
        if (this.eventsBatch.size() > 0) {
            this.postEventsAsync(this.eventsBatch);
        }
        this.eventsBatch = new LinkedList<HttpEventCollectorEventInfo>();
        this.eventsBatchSize = 0L;
    }

    public synchronized void flush(boolean close) {
        this.flush();
        if (close) {
            this.stopHttpClient();
        }
    }

    void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.flush();
        this.stopHttpClient();
        super.cancel();
    }

    @Override
    public void run() {
        this.flush();
    }

    public void disableCertificateValidation() {
        this.disableCertificateValidation = true;
    }

    public void setEventBodySerializer(EventBodySerializer eventBodySerializer) {
        this.serializer.setEventBodySerializer(eventBodySerializer);
    }

    public static void putIfPresent(JsonObject collection, String tag, Object value) {
        if (value != null) {
            if (value instanceof String && ((String)value).length() == 0) {
                return;
            }
            collection.add(tag, gson.toJsonTree(value));
        }
    }

    private void stopHttpClient() {
        if (httpClient != null) {
            httpClient.dispatcher().executorService().shutdown();
            httpClient = null;
        }
    }

    private void startHttpClient() {
        if (httpClient != null) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (this.sendMode == SendMode.Sequential) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(1);
            builder.dispatcher(dispatcher);
        }
        if (this.disableCertificateValidation) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        httpClient = builder.build();
    }

    private void postEventsAsync(final List<HttpEventCollectorEventInfo> events) {
        this.middleware.postEvents(events, this, new HttpEventCollectorMiddleware.IHttpSenderCallback(){

            @Override
            public void completed(int statusCode, String reply) {
                if (statusCode != 200) {
                    HttpEventCollectorErrorHandler.error(events, new HttpEventCollectorErrorHandler.ServerErrorException(reply));
                }
            }

            @Override
            public void failed(Exception ex) {
                HttpEventCollectorErrorHandler.error(events, new HttpEventCollectorErrorHandler.ServerErrorException(ex.getMessage()));
            }
        });
    }

    @Override
    public void postEvents(List<HttpEventCollectorEventInfo> events, final HttpEventCollectorMiddleware.IHttpSenderCallback callback) {
        this.startHttpClient();
        StringBuilder eventsBatchString = new StringBuilder();
        for (HttpEventCollectorEventInfo eventInfo : events) {
            eventsBatchString.append(this.serializer.serialize(eventInfo));
        }
        Request.Builder requestBldr = new Request.Builder().url(this.url).addHeader(AuthorizationHeaderTag, String.format(AuthorizationHeaderScheme, this.token)).post(RequestBody.create((MediaType)MediaType.parse((String)HttpContentType), (String)eventsBatchString.toString()));
        if ("Raw".equalsIgnoreCase(this.type) && this.channel != null && !this.channel.trim().equals("")) {
            requestBldr.addHeader(SPLUNKREQUESTCHANNELTag, this.channel);
        }
        httpClient.newCall(requestBldr.build()).enqueue(new Callback(){

            public void onResponse(Call call, Response response) {
                String reply = "";
                int httpStatusCode = response.code();
                try (ResponseBody body = response.body();){
                    if (httpStatusCode != 200 && body != null) {
                        try {
                            reply = body.string();
                        }
                        catch (IOException e) {
                            reply = e.getMessage();
                        }
                    }
                }
                callback.completed(httpStatusCode, reply);
            }

            public void onFailure(Call call, IOException ex) {
                callback.failed(ex);
            }
        });
    }

    public static enum SendMode {
        Sequential,
        Parallel;

    }
}

