/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.HttpEventCollectorEventInfo;
import java.util.List;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class HttpEventCollectorErrorHandler {
    private static ErrorCallback errorCallback;

    public static void onError(ErrorCallback callback) {
        errorCallback = callback;
    }

    public static void error(List<HttpEventCollectorEventInfo> data, Exception ex) {
        if (errorCallback != null) {
            errorCallback.error(data, ex);
        }
    }

    public static interface ErrorCallback {
        public void error(List<HttpEventCollectorEventInfo> var1, Exception var2);
    }

    public static class ServerErrorException
    extends Exception {
        private String reply;
        private long errorCode = -1L;
        private String errorText = "unknown error";

        public ServerErrorException(String serverReply) {
            this.reply = serverReply;
            JSONParser jsonParser = new JSONParser();
            try {
                JSONObject json = (JSONObject)jsonParser.parse(serverReply);
                this.errorCode = (Long)json.get((Object)"code");
                this.errorText = (String)json.get((Object)"text");
            }
            catch (Exception e) {
                this.errorText = e.getMessage();
            }
        }

        public String getReply() {
            return this.reply;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public String getErrorText() {
            return this.errorText;
        }

        @Override
        public String toString() {
            return this.getReply();
        }
    }
}

