/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;

public class HttpEventCollectorLogbackAppender<E>
extends AppenderBase<E> {
    private HttpEventCollectorSender sender = null;
    private Layout<E> _layout;
    private boolean _includeLoggerName = true;
    private boolean _includeThreadName = true;
    private boolean _includeMDC = true;
    private boolean _includeException = true;
    private String _source;
    private String _sourcetype;
    private String _host;
    private String _index;
    private String _url;
    private String _token;
    private String _disableCertificateValidation;
    private String _middleware;
    private long _batchInterval = 0L;
    private long _batchCount = 0L;
    private long _batchSize = 0L;
    private String _sendMode;
    private long _retriesOnError = 0L;

    public void start() {
        if (this.started) {
            return;
        }
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        if (this._host != null) {
            ((Dictionary)metadata).put("host", this._host);
        }
        if (this._index != null) {
            ((Dictionary)metadata).put("index", this._index);
        }
        if (this._source != null) {
            ((Dictionary)metadata).put("source", this._source);
        }
        if (this._sourcetype != null) {
            ((Dictionary)metadata).put("sourcetype", this._sourcetype);
        }
        this.sender = new HttpEventCollectorSender(this._url, this._token, this._batchInterval, this._batchCount, this._batchSize, this._sendMode, metadata);
        if (this._middleware != null && !this._middleware.isEmpty()) {
            try {
                this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)Class.forName(this._middleware).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._retriesOnError > 0L) {
            this.sender.addMiddleware(new HttpEventCollectorResendMiddleware(this._retriesOnError));
        }
        if (this._disableCertificateValidation != null && this._disableCertificateValidation.equalsIgnoreCase("true")) {
            this.sender.disableCertificateValidation();
        }
        super.start();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.sender.flush();
        super.stop();
    }

    protected void append(E e) {
        if (e instanceof ILoggingEvent) {
            this.sendEvent((ILoggingEvent)e);
        } else {
            this.sendEvent(e);
        }
    }

    private void sendEvent(ILoggingEvent event) {
        event.prepareForDeferredProcessing();
        if (event.hasCallerData()) {
            event.getCallerData();
        }
        MarkerConverter c = new MarkerConverter();
        if (event != null && this.started) {
            this.sender.send(event.getLevel().toString(), this._layout.doLayout((Object)event), this._includeLoggerName ? event.getLoggerName() : null, this._includeThreadName ? event.getThreadName() : null, this._includeMDC ? event.getMDCPropertyMap() : null, !this._includeException || event.getThrowableProxy() == null ? null : event.getThrowableProxy().getMessage(), (Serializable)((Object)c.convert(event)));
        }
    }

    private void sendEvent(E e) {
        String message = this._layout.doLayout(e);
        if (message == null) {
            throw new IllegalArgumentException(String.format("The logback layout %s is probably incorrect, and fails to format the message.", this._layout.toString()));
        }
        this.sender.send(message);
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUrl() {
        return this._url;
    }

    public void setToken(String token) {
        this._token = token;
    }

    public String getToken() {
        return this._token;
    }

    public void setLayout(Layout<E> layout) {
        this._layout = layout;
    }

    public Layout<E> getLayout() {
        return this._layout;
    }

    public boolean getIncludeLoggerName() {
        return this._includeLoggerName;
    }

    public void setIncludeLoggerName(boolean includeLoggerName) {
        this._includeLoggerName = includeLoggerName;
    }

    public boolean getIncludeThreadName() {
        return this._includeThreadName;
    }

    public void setIncludeThreadName(boolean includeThreadName) {
        this._includeThreadName = includeThreadName;
    }

    public boolean getIncludeMDC() {
        return this._includeMDC;
    }

    public void setIncludeMDC(boolean includeMDC) {
        this._includeMDC = includeMDC;
    }

    public boolean getIncludeException() {
        return this._includeException;
    }

    public void setIncludeException(boolean includeException) {
        this._includeException = includeException;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public String getSource() {
        return this._source;
    }

    public void setSourcetype(String sourcetype) {
        this._sourcetype = sourcetype;
    }

    public String getSourcetype() {
        return this._sourcetype;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setIndex(String index) {
        this._index = index;
    }

    public String getIndex() {
        return this._index;
    }

    public void setDisableCertificateValidation(String disableCertificateValidation) {
        this._disableCertificateValidation = disableCertificateValidation;
    }

    public void setbatch_size_count(String value) {
        this._batchCount = HttpEventCollectorLogbackAppender.parseLong(value, 10);
    }

    public void setbatch_size_bytes(String value) {
        this._batchSize = HttpEventCollectorLogbackAppender.parseLong(value, 10240);
    }

    public void setbatch_interval(String value) {
        this._batchInterval = HttpEventCollectorLogbackAppender.parseLong(value, 10000);
    }

    public void setretries_on_error(String value) {
        this._retriesOnError = HttpEventCollectorLogbackAppender.parseLong(value, 0);
    }

    public void setsend_mode(String value) {
        this._sendMode = value;
    }

    public void setmiddleware(String value) {
        this._middleware = value;
    }

    public String getDisableCertificateValidation() {
        return this._disableCertificateValidation;
    }

    private static long parseLong(String string, int defaultValue) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

