/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorEventInfo;
import com.splunk.logging.HttpEventCollectorMiddleware;
import java.io.IOException;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;

final class HttpEventCollectorSender
extends TimerTask
implements HttpEventCollectorMiddleware.IHttpSender {
    public static final String MetadataTimeTag = "time";
    public static final String MetadataHostTag = "host";
    public static final String MetadataIndexTag = "index";
    public static final String MetadataSourceTag = "source";
    public static final String MetadataSourceTypeTag = "sourcetype";
    private static final String AuthorizationHeaderTag = "Authorization";
    private static final String AuthorizationHeaderScheme = "Splunk %s";
    private static final String HttpEventCollectorUriPath = "/services/collector/event/1.0";
    private static final String HttpContentType = "application/json; profile=urn:splunk:event:1.0; charset=utf-8";
    private static final String SendModeSequential = "sequential";
    private static final String SendModeSParallel = "parallel";
    public static final int DefaultBatchInterval = 10000;
    public static final int DefaultBatchSize = 10240;
    public static final int DefaultBatchCount = 10;
    private String url;
    private String token;
    private long maxEventsBatchCount;
    private long maxEventsBatchSize;
    private Dictionary<String, String> metadata;
    private Timer timer;
    private List<HttpEventCollectorEventInfo> eventsBatch = new LinkedList<HttpEventCollectorEventInfo>();
    private long eventsBatchSize = 0L;
    private CloseableHttpAsyncClient httpClient;
    private boolean disableCertificateValidation = false;
    private SendMode sendMode = SendMode.Sequential;
    private HttpEventCollectorMiddleware middleware = new HttpEventCollectorMiddleware();

    public HttpEventCollectorSender(String Url, String token, long delay, long maxEventsBatchCount, long maxEventsBatchSize, String sendModeStr, Dictionary<String, String> metadata) {
        this.url = Url + HttpEventCollectorUriPath;
        this.token = token;
        if (maxEventsBatchCount == 0L && maxEventsBatchSize > 0L) {
            maxEventsBatchCount = Long.MAX_VALUE;
        } else if (maxEventsBatchSize == 0L && maxEventsBatchCount > 0L) {
            maxEventsBatchSize = Long.MAX_VALUE;
        }
        this.maxEventsBatchCount = maxEventsBatchCount;
        this.maxEventsBatchSize = maxEventsBatchSize;
        this.metadata = metadata;
        if (sendModeStr != null) {
            if (sendModeStr.equals(SendModeSequential)) {
                this.sendMode = SendMode.Sequential;
            } else if (sendModeStr.equals(SendModeSParallel)) {
                this.sendMode = SendMode.Parallel;
            } else {
                throw new IllegalArgumentException("Unknown send mode: " + sendModeStr);
            }
        }
        if (delay > 0L) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)this, delay, delay);
        }
    }

    public void addMiddleware(HttpEventCollectorMiddleware.HttpSenderMiddleware middleware) {
        this.middleware.add(middleware);
    }

    public synchronized void send(String severity, String message, String logger_name, String thread_name, Map<String, String> properties, String exception_message, Serializable marker) {
        HttpEventCollectorEventInfo eventInfo = new HttpEventCollectorEventInfo(severity, message, logger_name, thread_name, properties, exception_message, marker);
        this.eventsBatch.add(eventInfo);
        this.eventsBatchSize += (long)(severity.length() + message.length());
        if ((long)this.eventsBatch.size() >= this.maxEventsBatchCount || this.eventsBatchSize > this.maxEventsBatchSize) {
            this.flush();
        }
    }

    public synchronized void flush() {
        if (this.eventsBatch.size() > 0) {
            this.postEventsAsync(this.eventsBatch);
        }
        this.eventsBatch = new LinkedList<HttpEventCollectorEventInfo>();
        this.eventsBatchSize = 0L;
    }

    public void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.flush();
    }

    @Override
    public void run() {
        this.flush();
    }

    public void disableCertificateValidation() {
        this.disableCertificateValidation = true;
    }

    private static void putIfPresent(JSONObject collection, String tag, String value) {
        if (value != null && value.length() > 0) {
            collection.put((Object)tag, (Object)value);
        }
    }

    private String serializeEventInfo(HttpEventCollectorEventInfo eventInfo) {
        Serializable marker;
        Map<String, String> props;
        JSONObject event = new JSONObject();
        HttpEventCollectorSender.putIfPresent(event, MetadataTimeTag, String.format(Locale.US, "%.3f", eventInfo.getTime()));
        HttpEventCollectorSender.putIfPresent(event, MetadataHostTag, this.metadata.get(MetadataHostTag));
        HttpEventCollectorSender.putIfPresent(event, MetadataIndexTag, this.metadata.get(MetadataIndexTag));
        HttpEventCollectorSender.putIfPresent(event, MetadataSourceTag, this.metadata.get(MetadataSourceTag));
        HttpEventCollectorSender.putIfPresent(event, MetadataSourceTypeTag, this.metadata.get(MetadataSourceTypeTag));
        JSONObject body = new JSONObject();
        HttpEventCollectorSender.putIfPresent(body, "severity", eventInfo.getSeverity());
        HttpEventCollectorSender.putIfPresent(body, "message", eventInfo.getMessage());
        HttpEventCollectorSender.putIfPresent(body, "logger", eventInfo.getLoggerName());
        HttpEventCollectorSender.putIfPresent(body, "thread", eventInfo.getThreadName());
        if (eventInfo.getExceptionMessage() != null) {
            HttpEventCollectorSender.putIfPresent(body, "exception", eventInfo.getExceptionMessage());
        }
        if ((props = eventInfo.getProperties()) != null && !props.isEmpty()) {
            body.put((Object)"properties", props);
        }
        if ((marker = eventInfo.getMarker()) != null) {
            HttpEventCollectorSender.putIfPresent(body, "marker", marker.toString());
        }
        event.put((Object)"event", (Object)body);
        return event.toString();
    }

    private void startHttpClient() {
        int maxConnTotal;
        if (this.httpClient != null) {
            return;
        }
        int n = maxConnTotal = this.sendMode == SendMode.Sequential ? 1 : 0;
        if (!this.disableCertificateValidation) {
            this.httpClient = HttpAsyncClients.custom().setMaxConnTotal(maxConnTotal).build();
        } else {
            TrustStrategy acceptingTrustStrategy = new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] certificate, String type) {
                    return true;
                }
            };
            SSLContext sslContext = null;
            try {
                sslContext = SSLContexts.custom().loadTrustMaterial(null, acceptingTrustStrategy).build();
                this.httpClient = HttpAsyncClients.custom().setMaxConnTotal(maxConnTotal).setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER).setSSLContext(sslContext).build();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.httpClient.start();
    }

    private void stopHttpClient() throws SecurityException {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.httpClient = null;
        }
    }

    private void postEventsAsync(final List<HttpEventCollectorEventInfo> events) {
        this.middleware.postEvents(events, this, new HttpEventCollectorMiddleware.IHttpSenderCallback(){

            @Override
            public void completed(int statusCode, String reply) {
                if (statusCode != 200) {
                    HttpEventCollectorErrorHandler.error(events, new HttpEventCollectorErrorHandler.ServerErrorException(reply));
                }
            }

            @Override
            public void failed(Exception ex) {
                HttpEventCollectorErrorHandler.error(HttpEventCollectorSender.this.eventsBatch, new HttpEventCollectorErrorHandler.ServerErrorException(ex.getMessage()));
            }
        });
    }

    @Override
    public void postEvents(List<HttpEventCollectorEventInfo> events, final HttpEventCollectorMiddleware.IHttpSenderCallback callback) {
        this.startHttpClient();
        String encoding = "utf-8";
        StringBuilder eventsBatchString = new StringBuilder();
        for (HttpEventCollectorEventInfo eventInfo : events) {
            eventsBatchString.append(this.serializeEventInfo(eventInfo));
        }
        HttpPost httpPost = new HttpPost(this.url);
        httpPost.setHeader(AuthorizationHeaderTag, String.format(AuthorizationHeaderScheme, this.token));
        StringEntity entity = new StringEntity(eventsBatchString.toString(), "utf-8");
        entity.setContentType(HttpContentType);
        httpPost.setEntity((HttpEntity)entity);
        this.httpClient.execute((HttpUriRequest)httpPost, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                String reply = "";
                int httpStatusCode = response.getStatusLine().getStatusCode();
                if (httpStatusCode != 200) {
                    try {
                        reply = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                    }
                    catch (IOException e) {
                        reply = e.getMessage();
                    }
                }
                callback.completed(httpStatusCode, reply);
            }

            public void failed(Exception ex) {
                callback.failed(ex);
            }

            public void cancelled() {
            }
        });
    }

    public static enum SendMode {
        Sequential,
        Parallel;

    }
}

