/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public final class HttpEventCollectorLoggingHandler
extends Handler {
    private HttpEventCollectorSender sender = null;
    private final String BatchDelayConfTag = "batch_interval";
    private final String BatchCountConfTag = "batch_size_count";
    private final String BatchSizeConfTag = "batch_size_bytes";
    private final String RetriesOnErrorTag = "retries_on_error";
    private final String UrlConfTag = "url";
    private final String SendModeTag = "send_mode";
    private final String MiddlewareTag = "middleware";

    public HttpEventCollectorLoggingHandler() {
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        ((Dictionary)metadata).put("host", this.getConfigurationProperty("host", ""));
        ((Dictionary)metadata).put("index", this.getConfigurationProperty("index", ""));
        ((Dictionary)metadata).put("source", this.getConfigurationProperty("source", ""));
        ((Dictionary)metadata).put("sourcetype", this.getConfigurationProperty("sourcetype", ""));
        String url = this.getConfigurationProperty("url", null);
        String token = this.getConfigurationProperty("token", null);
        long delay = this.getConfigurationNumericProperty("batch_interval", 10000L);
        long batchCount = this.getConfigurationNumericProperty("batch_size_count", 10L);
        long batchSize = this.getConfigurationNumericProperty("batch_size_bytes", 10240L);
        long retriesOnError = this.getConfigurationNumericProperty("retries_on_error", 0L);
        String sendMode = this.getConfigurationProperty("send_mode", "sequential");
        String middleware = this.getConfigurationProperty("middleware", "");
        this.sender = new HttpEventCollectorSender(url, token, delay, batchCount, batchSize, sendMode, metadata);
        if (middleware != null && !middleware.isEmpty()) {
            try {
                this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)Class.forName(middleware).newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retriesOnError > 0L) {
            this.sender.addMiddleware(new HttpEventCollectorResendMiddleware(retriesOnError));
        }
        if (this.getConfigurationProperty("disableCertificateValidation", "false").equalsIgnoreCase("true")) {
            this.sender.disableCertificateValidation();
        }
    }

    @Override
    public void publish(LogRecord record) {
        this.sender.send(record.getLevel().toString(), record.getMessage(), record.getLoggerName(), String.format(Locale.US, "%d", record.getThreadID()), null, record.getThrown() == null ? null : record.getThrown().getMessage(), null);
    }

    @Override
    public void flush() {
        this.sender.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.sender.close();
    }

    private String getConfigurationProperty(String property, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(this.getClass().getName() + '.' + property);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Configuration property %s is missing", property));
        }
        return value;
    }

    private long getConfigurationNumericProperty(String property, long defaultValue) {
        return Integer.parseInt(this.getConfigurationProperty(property, String.format("%d", defaultValue)));
    }
}

