/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="Http", category="Core", elementType="appender", printObject=true)
public final class HttpEventCollectorLog4jAppender
extends AbstractAppender {
    private HttpEventCollectorSender sender = null;

    private HttpEventCollectorLog4jAppender(String name, String url, String token, String source, String sourcetype, String index, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, long batchInterval, long batchCount, long batchSize, long retriesOnError, String sendMode, String middleware, String disableCertificateValidation) {
        super(name, filter, layout, ignoreExceptions);
        Hashtable<String, String> metadata = new Hashtable<String, String>();
        ((Dictionary)metadata).put("index", index != null ? index : "");
        ((Dictionary)metadata).put("source", source != null ? source : "");
        ((Dictionary)metadata).put("sourcetype", sourcetype != null ? sourcetype : "");
        this.sender = new HttpEventCollectorSender(url, token, batchInterval, batchCount, batchSize, sendMode, metadata);
        if (middleware != null && !middleware.isEmpty()) {
            try {
                this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)Class.forName(middleware).newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (retriesOnError > 0L) {
            this.sender.addMiddleware(new HttpEventCollectorResendMiddleware(retriesOnError));
        }
        if (disableCertificateValidation != null && disableCertificateValidation.equalsIgnoreCase("true")) {
            this.sender.disableCertificateValidation();
        }
    }

    @PluginFactory
    public static HttpEventCollectorLog4jAppender createAppender(@PluginAttribute(value="url") String url, @PluginAttribute(value="token") String token, @PluginAttribute(value="name") String name, @PluginAttribute(value="source") String source, @PluginAttribute(value="sourcetype") String sourcetype, @PluginAttribute(value="index") String index, @PluginAttribute(value="ignoreExceptions") String ignore, @PluginAttribute(value="batch_size_bytes") String batchSize, @PluginAttribute(value="batch_size_count") String batchCount, @PluginAttribute(value="batch_interval") String batchInterval, @PluginAttribute(value="retries_on_error") String retriesOnError, @PluginAttribute(value="send_mode") String sendMode, @PluginAttribute(value="middleware") String middleware, @PluginAttribute(value="disableCertificateValidation") String disableCertificateValidation, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for HttpEventCollectorLog4jAppender");
            return null;
        }
        if (url == null) {
            LOGGER.error("No Splunk URL provided for HttpEventCollectorLog4jAppender");
            return null;
        }
        if (token == null) {
            LOGGER.error("No token provided for HttpEventCollectorLog4jAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createLayout((String)"%m", null, null, (Charset)Charset.forName("UTF-8"), (boolean)true, (boolean)false, null, null);
        }
        boolean ignoreExceptions = true;
        return new HttpEventCollectorLog4jAppender(name, url, token, source, sourcetype, index, filter, (Layout<? extends Serializable>)layout, true, HttpEventCollectorLog4jAppender.parseInt((String)batchInterval, (int)10000), HttpEventCollectorLog4jAppender.parseInt((String)batchCount, (int)10), HttpEventCollectorLog4jAppender.parseInt((String)batchSize, (int)10240), HttpEventCollectorLog4jAppender.parseInt((String)retriesOnError, (int)0), sendMode, middleware, disableCertificateValidation);
    }

    public void append(LogEvent event) {
        this.sender.send(event.getLevel().toString(), event.getMessage().getFormattedMessage());
    }

    public void stop() {
        this.sender.flush();
        super.stop();
    }
}

