/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.google.gson.Gson;
import com.splunk.logging.EventBodySerializer;
import com.splunk.logging.EventHeaderSerializer;
import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public final class HttpEventCollectorLoggingHandler
extends Handler {
    private HttpEventCollectorSender sender = null;
    private final String includeLoggerNameConfTag = "include_logger_name";
    private final boolean includeLoggerName;
    private final String includeThreadNameConfTag = "include_thread_name";
    private final boolean includeThreadName;
    private final String includeExceptionConfTag = "include_exception";
    private boolean includeException;
    private final String batchDelayConfTag = "batch_interval";
    private final String batchCountConfTag = "batch_size_count";
    private final String batchSizeConfTag = "batch_size_bytes";
    private final String retriesOnErrorTag = "retries_on_error";
    private final String urlConfTag = "url";
    private final String sendModeTag = "send_mode";
    private final String middlewareTag = "middleware";
    private final String connectTimeoutConfTag = "connect_timeout";
    private final String callTimeoutConfTag = "call_timeout";
    private final String readTimeoutConfTag = "read_timeout";
    private final String writeTimeoutConfTag = "write_timeout";
    private final String terminationTimeoutConfTag = "termination_timeout";

    public HttpEventCollectorLoggingHandler() {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("host", this.getConfigurationProperty("host", null));
        metadata.put("index", this.getConfigurationProperty("index", null));
        metadata.put("source", this.getConfigurationProperty("source", null));
        metadata.put("sourcetype", this.getConfigurationProperty("sourcetype", null));
        metadata.put("messageFormat", this.getConfigurationProperty("messageFormat", null));
        String url = this.getConfigurationProperty("url", null);
        String token = this.getConfigurationProperty("token", null);
        String channel = this.getConfigurationProperty("channel", null);
        String type = this.getConfigurationProperty("type", null);
        long delay = this.getConfigurationNumericProperty("batch_interval", 10000L);
        long batchCount = this.getConfigurationNumericProperty("batch_size_count", 10L);
        long batchSize = this.getConfigurationNumericProperty("batch_size_bytes", 10240L);
        long retriesOnError = this.getConfigurationNumericProperty("retries_on_error", 0L);
        String sendMode = this.getConfigurationProperty("send_mode", "sequential");
        String eventHeaderSerializer = this.getConfigurationProperty("eventHeaderSerializer", "");
        String middleware = this.getConfigurationProperty("middleware", null);
        String eventBodySerializer = this.getConfigurationProperty("eventBodySerializer", null);
        String errorCallbackClass = this.getConfigurationProperty("errorCallback", null);
        this.includeLoggerName = this.getConfigurationBooleanProperty("include_logger_name", true);
        this.includeThreadName = this.getConfigurationBooleanProperty("include_thread_name", true);
        this.includeException = this.getConfigurationBooleanProperty("include_exception", true);
        HttpEventCollectorSender.TimeoutSettings timeoutSettings = new HttpEventCollectorSender.TimeoutSettings(this.getConfigurationNumericProperty("connect_timeout", 3000L), this.getConfigurationNumericProperty("call_timeout", 0L), this.getConfigurationNumericProperty("read_timeout", 10000L), this.getConfigurationNumericProperty("write_timeout", 10000L), this.getConfigurationNumericProperty("termination_timeout", 0L));
        if ("raw".equalsIgnoreCase(type)) {
            if (batchCount != 10L || batchSize != 10240L || delay != 10000L) {
                throw new IllegalArgumentException("Batching configuration and sending type of raw are incompatible.");
            }
            batchCount = 1L;
        }
        this.sender = new HttpEventCollectorSender(url, token, channel, type, delay, batchCount, batchSize, sendMode, metadata, timeoutSettings);
        if (middleware != null && !middleware.isEmpty()) {
            try {
                this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)Class.forName(middleware).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (eventBodySerializer != null && !eventBodySerializer.isEmpty()) {
            try {
                this.sender.setEventBodySerializer((EventBodySerializer)Class.forName(eventBodySerializer).newInstance());
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        if (eventHeaderSerializer != null && !eventHeaderSerializer.isEmpty()) {
            try {
                this.sender.setEventHeaderSerializer((EventHeaderSerializer)Class.forName(eventHeaderSerializer).newInstance());
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        if (errorCallbackClass != null && !errorCallbackClass.isEmpty()) {
            try {
                HttpEventCollectorErrorHandler.registerClassName(errorCallbackClass);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        if (retriesOnError > 0L) {
            this.sender.addMiddleware(new HttpEventCollectorResendMiddleware(retriesOnError));
        }
        if (this.getConfigurationProperty("disableCertificateValidation", "false").equalsIgnoreCase("true")) {
            this.sender.disableCertificateValidation();
        }
    }

    @Override
    public void publish(LogRecord record) {
        boolean isExceptionOccured = false;
        String exceptionDetail = null;
        String formatConfiguration = null;
        String formattedMessage = null;
        if (Level.SEVERE.equals(record.getLevel()) && record.getThrown() != null) {
            LinkedHashMap<String, String> exceptionDetailMap = new LinkedHashMap<String, String>();
            StackTraceElement[] elements = record.getThrown().getStackTrace();
            exceptionDetailMap.put("detailMessage", record.getThrown().getMessage());
            exceptionDetailMap.put("exceptionClass", record.getThrown().getClass().toString());
            if (elements != null && elements.length > 0 && elements[0] != null) {
                exceptionDetailMap.put("fileName", elements[0].getFileName());
                exceptionDetailMap.put("lineNumber", String.valueOf(elements[0].getLineNumber()));
                exceptionDetailMap.put("methodName", elements[0].getMethodName());
            }
            exceptionDetail = new Gson().toJson(exceptionDetailMap);
            isExceptionOccured = true;
        }
        if ((formatConfiguration = this.getConfigurationProperty("formatter", null)) != null) {
            try {
                Object messageFormatter = Class.forName(formatConfiguration).newInstance();
                formattedMessage = ((Formatter)messageFormatter).format(record);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        } else {
            Formatter messageFormatter = this.getFormatter();
            if (messageFormatter == null) {
                messageFormatter = new SimpleFormatter();
            }
            formattedMessage = messageFormatter.formatMessage(record);
        }
        this.sender.send(record.getMillis(), record.getLevel().toString(), formattedMessage, this.includeLoggerName ? record.getLoggerName() : null, this.includeThreadName ? String.format(Locale.US, "%d", record.getThreadID()) : null, null, this.includeException && isExceptionOccured ? exceptionDetail : null, null);
    }

    @Override
    public void flush() {
        this.sender.flush();
    }

    @Override
    public void close() throws SecurityException {
        this.sender.close();
    }

    private String getConfigurationProperty(String property, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(this.getClass().getName() + '.' + property);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private long getConfigurationNumericProperty(String property, long defaultValue) {
        return Integer.parseInt(this.getConfigurationProperty(property, String.format("%d", defaultValue)));
    }

    private boolean getConfigurationBooleanProperty(String property, boolean defaultValue) {
        return Boolean.parseBoolean(this.getConfigurationProperty(property, String.valueOf(defaultValue)));
    }
}

