/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.splunk.logging.EventBodySerializer;
import com.splunk.logging.EventHeaderSerializer;
import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.HttpEventCollectorResendMiddleware;
import com.splunk.logging.HttpEventCollectorSender;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpEventCollectorLogbackAppender<E>
extends AppenderBase<E> {
    private HttpEventCollectorSender sender = null;
    private Layout<E> _layout;
    private boolean _includeLoggerName = true;
    private boolean _includeThreadName = true;
    private boolean _includeMDC = true;
    private boolean _includeException = true;
    private String _source;
    private String _sourcetype;
    private String _messageFormat;
    private String _host;
    private String _index;
    private String _url;
    private String _token;
    private String _channel;
    private String _type;
    private String _disableCertificateValidation;
    private String _middleware;
    private String _eventBodySerializer;
    private String _eventHeaderSerializer;
    private String _errorCallback;
    private long _batchInterval = 0L;
    private long _batchCount = 0L;
    private long _batchSize = 0L;
    private String _sendMode;
    private long _retriesOnError = 0L;
    private Map<String, String> _metadata = new HashMap<String, String>();
    private boolean _batchingConfigured = false;
    private HttpEventCollectorSender.TimeoutSettings timeoutSettings = new HttpEventCollectorSender.TimeoutSettings();

    public void start() {
        if (this.started) {
            return;
        }
        HashMap<String, String> metadata = new HashMap<String, String>(this._metadata);
        if (this._host != null) {
            metadata.put("host", this._host);
        }
        if (this._index != null) {
            metadata.put("index", this._index);
        }
        if (this._source != null) {
            metadata.put("source", this._source);
        }
        if (this._sourcetype != null) {
            metadata.put("sourcetype", this._sourcetype);
        }
        if (this._messageFormat != null) {
            metadata.put("messageFormat", this._messageFormat);
        }
        if ("raw".equalsIgnoreCase(this._type) && this._batchingConfigured) {
            throw new IllegalArgumentException("Batching configuration and sending type of raw are incompatible.");
        }
        this.sender = new HttpEventCollectorSender(this._url, this._token, this._channel, this._type, this._batchInterval, this._batchCount, this._batchSize, this._sendMode, metadata, this.timeoutSettings);
        if (this._middleware != null && !this._middleware.isEmpty()) {
            try {
                this.sender.addMiddleware((HttpEventCollectorMiddleware.HttpSenderMiddleware)Class.forName(this._middleware).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._eventBodySerializer != null && !this._eventBodySerializer.isEmpty()) {
            try {
                this.sender.setEventBodySerializer((EventBodySerializer)Class.forName(this._eventBodySerializer).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._eventHeaderSerializer != null && !this._eventHeaderSerializer.isEmpty()) {
            try {
                this.sender.setEventHeaderSerializer((EventHeaderSerializer)Class.forName(this._eventHeaderSerializer).newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._errorCallback != null && !this._errorCallback.isEmpty()) {
            HttpEventCollectorErrorHandler.registerClassName(this._errorCallback);
        }
        if (this._retriesOnError > 0L) {
            this.sender.addMiddleware(new HttpEventCollectorResendMiddleware(this._retriesOnError));
        }
        if (this._disableCertificateValidation != null && this._disableCertificateValidation.equalsIgnoreCase("true")) {
            this.sender.disableCertificateValidation();
        }
        super.start();
    }

    public void flush() {
        if (this.started) {
            this.sender.flush();
        }
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.sender.close();
        super.stop();
    }

    protected void append(E e) {
        if (e instanceof ILoggingEvent) {
            this.sendEvent((ILoggingEvent)e);
        } else {
            this.sendEvent(e);
        }
    }

    private void sendEvent(ILoggingEvent event) {
        event.prepareForDeferredProcessing();
        if (event.hasCallerData()) {
            event.getCallerData();
        }
        MarkerConverter c = new MarkerConverter();
        if (this.started) {
            this.sender.send(event.getTimeStamp(), event.getLevel().toString(), this._layout.doLayout((Object)event), this._includeLoggerName ? event.getLoggerName() : null, this._includeThreadName ? event.getThreadName() : null, this._includeMDC ? event.getMDCPropertyMap() : null, !this._includeException || event.getThrowableProxy() == null ? null : event.getThrowableProxy().getMessage(), (Serializable)((Object)c.convert(event)));
        }
    }

    private void sendEvent(E e) {
        String message = this._layout.doLayout(e);
        if (message == null) {
            throw new IllegalArgumentException(String.format("The logback layout %s is probably incorrect, and fails to format the message.", this._layout.toString()));
        }
        this.sender.send(message);
    }

    public void setUrl(String url) {
        this._url = url;
    }

    public String getUrl() {
        return this._url;
    }

    public void setToken(String token) {
        this._token = token;
    }

    public String getToken() {
        return this._token;
    }

    public void setChannel(String channel) {
        this._channel = channel;
    }

    public String getChannel() {
        return this._channel;
    }

    public void setType(String type) {
        this._type = type;
        if ("raw".equalsIgnoreCase(type)) {
            this.validateNotBatchedAndRaw();
            this._batchCount = 1L;
        }
    }

    private void validateNotBatchedAndRaw() {
        if ("raw".equalsIgnoreCase(this._type) && this._batchingConfigured) {
            throw new IllegalArgumentException("Batching configuration and sending type of raw are incompatible.");
        }
    }

    public String getType() {
        return this._type;
    }

    public void setLayout(Layout<E> layout) {
        this._layout = layout;
    }

    public Layout<E> getLayout() {
        return this._layout;
    }

    public boolean getIncludeLoggerName() {
        return this._includeLoggerName;
    }

    public void setIncludeLoggerName(boolean includeLoggerName) {
        this._includeLoggerName = includeLoggerName;
    }

    public boolean getIncludeThreadName() {
        return this._includeThreadName;
    }

    public void setIncludeThreadName(boolean includeThreadName) {
        this._includeThreadName = includeThreadName;
    }

    public boolean getIncludeMDC() {
        return this._includeMDC;
    }

    public void setIncludeMDC(boolean includeMDC) {
        this._includeMDC = includeMDC;
    }

    public boolean getIncludeException() {
        return this._includeException;
    }

    public void setIncludeException(boolean includeException) {
        this._includeException = includeException;
    }

    public void setSource(String source) {
        this._source = source;
    }

    public String getSource() {
        return this._source;
    }

    public void setSourcetype(String sourcetype) {
        this._sourcetype = sourcetype;
    }

    public String getSourcetype() {
        return this._sourcetype;
    }

    public void setMessageFormat(String messageFormat) {
        this._messageFormat = messageFormat;
    }

    public String getMessageFormat() {
        return this._messageFormat;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setIndex(String index) {
        this._index = index;
    }

    public String getIndex() {
        return this._index;
    }

    public void addMetadata(String tag, String value) {
        this._metadata.put(tag, value);
    }

    public String getEventBodySerializer() {
        return this._eventBodySerializer;
    }

    public String getEventHeaderSerializer() {
        return this._eventHeaderSerializer;
    }

    public String getErrorHandler(String errorHandlerClass) {
        return this._errorCallback;
    }

    public void setDisableCertificateValidation(String disableCertificateValidation) {
        this._disableCertificateValidation = disableCertificateValidation;
    }

    public void setbatch_size_count(String value) {
        this._batchCount = HttpEventCollectorLogbackAppender.parseLong(value, 10);
        this._batchingConfigured = true;
        this.validateNotBatchedAndRaw();
    }

    public void setbatch_size_bytes(String value) {
        this._batchSize = HttpEventCollectorLogbackAppender.parseLong(value, 10240);
        this._batchingConfigured = true;
        this.validateNotBatchedAndRaw();
    }

    public void setbatch_interval(String value) {
        this._batchInterval = HttpEventCollectorLogbackAppender.parseLong(value, 10000);
        this._batchingConfigured = true;
        this.validateNotBatchedAndRaw();
    }

    public void setretries_on_error(String value) {
        this._retriesOnError = HttpEventCollectorLogbackAppender.parseLong(value, 0);
    }

    public void setsend_mode(String value) {
        this._sendMode = value;
    }

    public void setmiddleware(String value) {
        this._middleware = value;
    }

    public String getDisableCertificateValidation() {
        return this._disableCertificateValidation;
    }

    public void setEventBodySerializer(String eventBodySerializer) {
        this._eventBodySerializer = eventBodySerializer;
    }

    public void setEventHeaderSerializer(String eventHeaderSerializer) {
        this._eventHeaderSerializer = eventHeaderSerializer;
    }

    public void setErrorCallback(String errorHandlerClass) {
        this._errorCallback = errorHandlerClass;
    }

    public String getErrorCallback() {
        return this._errorCallback;
    }

    public void setConnectTimeout(long milliseconds) {
        this.timeoutSettings.connectTimeout = milliseconds;
    }

    public long getConnectTimeout(long milliseconds) {
        this.timeoutSettings.connectTimeout = milliseconds;
        return this.timeoutSettings.connectTimeout;
    }

    public void setCallTimeout(long milliseconds) {
        this.timeoutSettings.callTimeout = milliseconds;
    }

    public long getCallTimeout(long milliseconds) {
        this.timeoutSettings.callTimeout = milliseconds;
        return this.timeoutSettings.callTimeout;
    }

    public void setReadTimeout(long milliseconds) {
        this.timeoutSettings.readTimeout = milliseconds;
    }

    public long getReadTimeout(long milliseconds) {
        this.timeoutSettings.readTimeout = milliseconds;
        return this.timeoutSettings.readTimeout;
    }

    public void setWriteTimeout(long milliseconds) {
        this.timeoutSettings.writeTimeout = milliseconds;
    }

    public long getWriteTimeout(long milliseconds) {
        this.timeoutSettings.writeTimeout = milliseconds;
        return this.timeoutSettings.writeTimeout;
    }

    public void setTerminationTimeout(long milliseconds) {
        this.timeoutSettings.terminationTimeout = milliseconds;
    }

    public long getTerminationTimeout(long milliseconds) {
        this.timeoutSettings.terminationTimeout = milliseconds;
        return this.timeoutSettings.terminationTimeout;
    }

    private static long parseLong(String string, int defaultValue) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

