/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.splunk.logging.EventBodySerializer;
import com.splunk.logging.EventHeaderSerializer;
import com.splunk.logging.HttpEventCollectorEventInfo;
import com.splunk.logging.hec.MetadataTags;
import com.splunk.logging.serialization.EventInfoTypeAdapter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class HecJsonSerializer {
    private static final Set<String> KEYWORDS = MetadataTags.HEC_TAGS;
    private Map<String, Object> template = new LinkedHashMap<String, Object>();
    private EventInfoTypeAdapter typeAdapter = new EventInfoTypeAdapter();
    private Gson gson = new GsonBuilder().registerTypeAdapter(HttpEventCollectorEventInfo.class, (Object)this.typeAdapter).disableHtmlEscaping().create();
    private EventBodySerializer eventBodySerializer;
    private EventHeaderSerializer eventHeaderSerializer;

    public HecJsonSerializer(Map<String, String> metadata) {
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            this.setValue(entry.getKey(), entry.getValue());
        }
    }

    private void setValue(String key, String value) {
        if (KEYWORDS.contains(key)) {
            this.template.put(key, value);
        } else {
            Object fields;
            if (!this.template.containsKey("fields")) {
                this.template.put("fields", new HashMap());
            }
            if ((fields = this.template.get("fields")) instanceof Map) {
                ((Map)fields).put(key, value);
            }
        }
    }

    public String serialize(HttpEventCollectorEventInfo info) {
        Map<String, Object> event = this.eventHeaderSerializer != null ? this.eventHeaderSerializer.serializeEventHeader(info, new HashMap<String, Object>(this.template)) : new HashMap<String, Object>(this.template);
        if (this.eventBodySerializer != null) {
            event.put("event", this.eventBodySerializer.serializeEventBody(info, info.getMessage()));
            double eventTime = this.eventBodySerializer.getEventTime(info);
            if (eventTime > 0.0) {
                event.put("time", String.format(Locale.US, "%.3f", eventTime));
            }
        } else {
            event.put("event", info);
        }
        return this.gson.toJson(event);
    }

    public void setEventBodySerializer(EventBodySerializer eventBodySerializer) {
        this.eventBodySerializer = eventBodySerializer;
    }

    public void setEventHeaderSerializer(EventHeaderSerializer eventHeaderSerializer) {
        this.eventHeaderSerializer = eventHeaderSerializer;
    }
}

