/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.splunk.logging.HttpEventCollectorEventInfo;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class EventInfoTypeAdapter
implements JsonSerializer<HttpEventCollectorEventInfo> {
    public JsonElement serialize(HttpEventCollectorEventInfo src, Type typeOfSrc, JsonSerializationContext context) {
        String markerString;
        Map<String, String> props;
        HashMap<String, Object> event = new HashMap<String, Object>();
        JsonParser parser = new JsonParser();
        if (src.getTime() > 0.0) {
            event.put("time", String.format(Locale.US, "%.3f", src.getTime()));
        }
        if (src.getSeverity() != null) {
            event.put("severity", src.getSeverity());
        }
        try {
            event.put("message", parser.parse(src.getMessage()));
        }
        catch (JsonSyntaxException e) {
            event.put("message", src.getMessage());
        }
        if (src.getLoggerName() != null && !src.getLoggerName().isEmpty()) {
            event.put("logger", src.getLoggerName());
        }
        if (src.getThreadName() != null && !src.getThreadName().isEmpty()) {
            event.put("thread", src.getThreadName());
        }
        if (src.getExceptionMessage() != null && !src.getExceptionMessage().isEmpty()) {
            event.put("exception", src.getExceptionMessage());
        }
        if ((props = src.getProperties()) != null && props.size() > 0) {
            event.put("properties", props);
        }
        if (src.getMarker() != null && !(markerString = src.getMarker().toString()).isEmpty()) {
            event.put("marker", src.getMarker().toString());
        }
        return context.serialize(event);
    }
}

