/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.splunk.logging.EventBodySerializer;
import com.splunk.logging.EventHeaderSerializer;
import com.splunk.logging.HttpEventCollectorErrorHandler;
import com.splunk.logging.HttpEventCollectorEventInfo;
import com.splunk.logging.HttpEventCollectorMiddleware;
import com.splunk.logging.serialization.EventInfoTypeAdapter;
import com.splunk.logging.serialization.HecJsonSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class HttpEventCollectorSender
extends TimerTask
implements HttpEventCollectorMiddleware.IHttpSender {
    private static final String ChannelQueryParam = "channel";
    private static final String AuthorizationHeaderTag = "Authorization";
    private static final String AuthorizationHeaderScheme = "Splunk %s";
    private static final String HttpEventCollectorUriPath = "/services/collector/event/1.0";
    private static final String HttpRawCollectorUriPath = "/services/collector/raw";
    private static final String JsonHttpContentType = "application/json; profile=urn:splunk:event:1.0; charset=utf-8";
    private static final String PlainTextHttpContentType = "plain/text; charset=utf-8";
    private static final String SendModeSequential = "sequential";
    private static final String SendModeSParallel = "parallel";
    private TimeoutSettings timeoutSettings = new TimeoutSettings();
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(HttpEventCollectorEventInfo.class, (Object)new EventInfoTypeAdapter()).create();
    private final HecJsonSerializer serializer;
    public static final int DefaultBatchInterval = 10000;
    public static final int DefaultBatchSize = 10240;
    public static final int DefaultBatchCount = 10;
    private HttpUrl url;
    private String token;
    private String channel;
    private String type;
    private long maxEventsBatchCount;
    private long maxEventsBatchSize;
    private Timer timer;
    private List<HttpEventCollectorEventInfo> eventsBatch = new LinkedList<HttpEventCollectorEventInfo>();
    private long eventsBatchSize = 0L;
    private static final OkHttpClient httpSharedClient = new OkHttpClient();
    private OkHttpClient httpClient = null;
    private boolean disableCertificateValidation = false;
    private SendMode sendMode = SendMode.Sequential;
    private HttpEventCollectorMiddleware middleware = new HttpEventCollectorMiddleware();

    public HttpEventCollectorSender(String Url, String token, String channel, String type, long delay, long maxEventsBatchCount, long maxEventsBatchSize, String sendModeStr, Map<String, String> metadata, TimeoutSettings timeoutSettings) {
        this.token = token;
        this.channel = channel;
        this.type = type;
        if (timeoutSettings != null) {
            this.timeoutSettings = timeoutSettings;
        }
        if ("Raw".equalsIgnoreCase(type)) {
            HttpUrl fullUrl;
            if (channel == null || channel.trim().equals("")) {
                this.channel = UUID.randomUUID().toString();
            }
            if ((fullUrl = HttpUrl.parse((String)(Url + HttpRawCollectorUriPath))) == null) {
                throw new IllegalArgumentException(String.format("Unparseable URL argument: %s", Url + HttpEventCollectorUriPath));
            }
            HttpUrl.Builder urlBuilder = fullUrl.newBuilder().addQueryParameter(ChannelQueryParam, channel);
            metadata.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
            this.url = urlBuilder.build();
        } else {
            this.url = HttpUrl.parse((String)(Url + HttpEventCollectorUriPath));
        }
        if (maxEventsBatchCount == 0L && maxEventsBatchSize > 0L) {
            maxEventsBatchCount = Long.MAX_VALUE;
        } else if (maxEventsBatchSize == 0L && maxEventsBatchCount > 0L) {
            maxEventsBatchSize = Long.MAX_VALUE;
        }
        this.maxEventsBatchCount = maxEventsBatchCount;
        this.maxEventsBatchSize = maxEventsBatchSize;
        this.serializer = new HecJsonSerializer(metadata);
        String format = metadata.get("messageFormat");
        if (sendModeStr != null) {
            if (sendModeStr.equals(SendModeSequential)) {
                this.sendMode = SendMode.Sequential;
            } else if (sendModeStr.equals(SendModeSParallel)) {
                this.sendMode = SendMode.Parallel;
            } else {
                throw new IllegalArgumentException("Unknown send mode: " + sendModeStr);
            }
        }
        if (delay > 0L) {
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate((TimerTask)this, delay, delay);
        }
    }

    public void addMiddleware(HttpEventCollectorMiddleware.HttpSenderMiddleware middleware) {
        this.middleware.add(middleware);
    }

    public synchronized void send(long timeMsSinceEpoch, String severity, String message, String logger_name, String thread_name, Map<String, String> properties, String exception_message, Serializable marker) {
        HttpEventCollectorEventInfo eventInfo = new HttpEventCollectorEventInfo(timeMsSinceEpoch, severity, message, logger_name, thread_name, properties, exception_message, marker);
        this.eventsBatch.add(eventInfo);
        this.eventsBatchSize += (long)(severity.length() + message.length());
        if ((long)this.eventsBatch.size() >= this.maxEventsBatchCount || this.eventsBatchSize > this.maxEventsBatchSize) {
            this.flush();
        }
    }

    public synchronized void send(String message) {
        this.send(System.currentTimeMillis(), "", message, "", "", null, null, (Serializable)((Object)""));
    }

    public synchronized void flush() {
        if (this.eventsBatch.size() > 0) {
            this.postEventsAsync(this.eventsBatch);
        }
        this.eventsBatch = new LinkedList<HttpEventCollectorEventInfo>();
        this.eventsBatchSize = 0L;
    }

    public synchronized void flush(boolean close) {
        this.flush();
        if (close) {
            this.stopHttpClient();
        }
    }

    void close() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.flush();
        this.stopHttpClient();
        super.cancel();
    }

    @Override
    public void run() {
        this.flush();
    }

    public void disableCertificateValidation() {
        this.disableCertificateValidation = true;
    }

    public void setEventBodySerializer(EventBodySerializer eventBodySerializer) {
        this.serializer.setEventBodySerializer(eventBodySerializer);
    }

    public void setEventHeaderSerializer(EventHeaderSerializer eventHeaderSerializer) {
        this.serializer.setEventHeaderSerializer(eventHeaderSerializer);
    }

    public static void putIfPresent(JsonObject collection, String tag, Object value) {
        if (value != null) {
            if (value instanceof String && ((String)value).length() == 0) {
                return;
            }
            collection.add(tag, gson.toJsonTree(value));
        }
    }

    private void stopHttpClient() {
        if (this.httpClient != null) {
            Dispatcher dispatcher = this.httpClient.dispatcher();
            this.httpClient = null;
            if (this.timeoutSettings.terminationTimeout > 0L) {
                long start = System.currentTimeMillis();
                while (dispatcher.queuedCallsCount() > 0 && start + this.timeoutSettings.terminationTimeout > System.currentTimeMillis()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
                dispatcher.executorService().shutdown();
                long awaitTerminationTimeout = this.timeoutSettings.terminationTimeout - (System.currentTimeMillis() - start);
                if (awaitTerminationTimeout > 0L) {
                    try {
                        dispatcher.executorService().awaitTermination(awaitTerminationTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            } else {
                dispatcher.executorService().shutdown();
            }
        }
    }

    private void startHttpClient() {
        if (this.httpClient != null) {
            return;
        }
        OkHttpClient.Builder builder = httpSharedClient.newBuilder();
        if (this.sendMode == SendMode.Sequential) {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(1);
            builder.dispatcher(dispatcher);
        }
        if (this.disableCertificateValidation) {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            try {
                SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
                builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            builder.hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
        }
        this.httpClient = builder.build();
    }

    private void postEventsAsync(final List<HttpEventCollectorEventInfo> events) {
        this.middleware.postEvents(events, this, new HttpEventCollectorMiddleware.IHttpSenderCallback(){

            @Override
            public void completed(int statusCode, String reply) {
                if (statusCode != 200) {
                    HttpEventCollectorErrorHandler.error(events, new HttpEventCollectorErrorHandler.ServerErrorException(reply));
                }
            }

            @Override
            public void failed(Exception ex) {
                HttpEventCollectorErrorHandler.error(events, new HttpEventCollectorErrorHandler.ServerErrorException(ex.getMessage()));
            }
        });
    }

    @Override
    public void postEvents(List<HttpEventCollectorEventInfo> events, final HttpEventCollectorMiddleware.IHttpSenderCallback callback) {
        this.startHttpClient();
        Request.Builder requestBldr = new Request.Builder().url(this.url).addHeader(AuthorizationHeaderTag, String.format(AuthorizationHeaderScheme, this.token));
        if ("Raw".equalsIgnoreCase(this.type)) {
            String lineSeparatedEvents = events.stream().map(HttpEventCollectorEventInfo::getMessage).collect(Collectors.joining(System.lineSeparator()));
            requestBldr.post(RequestBody.create((MediaType)MediaType.parse((String)PlainTextHttpContentType), (String)lineSeparatedEvents));
        } else {
            StringBuilder eventsBatchString = new StringBuilder();
            for (HttpEventCollectorEventInfo eventInfo : events) {
                eventsBatchString.append(this.serializer.serialize(eventInfo));
            }
            requestBldr.post(RequestBody.create((MediaType)MediaType.parse((String)JsonHttpContentType), (String)eventsBatchString.toString()));
        }
        this.httpClient.newCall(requestBldr.build()).enqueue(new Callback(){

            public void onResponse(Call call, Response response) {
                String reply = "";
                int httpStatusCode = response.code();
                try (ResponseBody body = response.body();){
                    if (httpStatusCode != 200 && body != null) {
                        try {
                            reply = body.string();
                        }
                        catch (IOException e) {
                            reply = e.getMessage();
                        }
                    }
                }
                callback.completed(httpStatusCode, reply);
            }

            public void onFailure(Call call, IOException ex) {
                callback.failed(ex);
            }
        });
    }

    public static class TimeoutSettings {
        public static final long DEFAULT_CONNECT_TIMEOUT = 30000L;
        public static final long DEFAULT_WRITE_TIMEOUT = 0L;
        public static final long DEFAULT_CALL_TIMEOUT = 0L;
        public static final long DEFAULT_READ_TIMEOUT = 0L;
        public static final long DEFAULT_TERMINATION_TIMEOUT = 0L;
        public long connectTimeout = 30000L;
        public long callTimeout = 0L;
        public long readTimeout = 0L;
        public long writeTimeout = 0L;
        public long terminationTimeout = 0L;

        public TimeoutSettings() {
        }

        public TimeoutSettings(long connectTimeout, long callTimeout, long readTimeout, long writeTimeout, long terminationTimeout) {
            this.connectTimeout = connectTimeout;
            this.callTimeout = callTimeout;
            this.readTimeout = readTimeout;
            this.writeTimeout = writeTimeout;
            this.terminationTimeout = terminationTimeout;
        }
    }

    public static enum SendMode {
        Sequential,
        Parallel;

    }
}

