/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.util.CloseUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.SocketFactory;

public class TcpAppender
extends AppenderBase<ILoggingEvent>
implements Runnable,
SocketConnector.ExceptionHandler {
    private static final int DEFAULT_RECONNECTION_DELAY = 30000;
    private static final int DEFAULT_QUEUE_SIZE = 0;
    private static final int DEFAULT_ACCEPT_CONNECTION_DELAY = 5000;
    private String host;
    private int port;
    private InetAddress address;
    private Layout<ILoggingEvent> layout;
    private Future<?> task;
    private Future<Socket> connectorTask;
    private int reconnectionDelay = 30000;
    private int queueSize = 0;
    private int acceptConnectionTimeout = 5000;
    private BlockingQueue<ILoggingEvent> queue;
    private volatile Socket socket;

    public void connectionFailed(SocketConnector socketConnector, Exception e) {
        if (e instanceof InterruptedException) {
            this.addInfo("connector interrupted");
        } else if (e instanceof ConnectException) {
            this.addInfo(this.host + ":" + this.port + " connection refused");
        } else {
            this.addInfo(this.host + ":" + this.port + " " + e);
        }
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                DefaultSocketConnector connector = new DefaultSocketConnector(this.address, this.port, 0, this.reconnectionDelay);
                connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
                connector.setSocketFactory(SocketFactory.getDefault());
                try {
                    this.connectorTask = this.getContext().getExecutorService().submit(connector);
                }
                catch (RejectedExecutionException e) {
                    this.connectorTask = null;
                    break;
                }
                try {
                    this.socket = this.connectorTask.get();
                    this.connectorTask = null;
                }
                catch (ExecutionException e) {
                    this.socket = null;
                    break;
                }
                try {
                    this.socket.setSoTimeout(this.acceptConnectionTimeout);
                    OutputStreamWriter writer = new OutputStreamWriter(this.socket.getOutputStream());
                    this.socket.setSoTimeout(0);
                    this.addInfo(this.host + ":" + this.port + " connection established");
                    while (true) {
                        ILoggingEvent event = this.queue.take();
                        String formatted = this.layout.doLayout((Object)event);
                        writer.write(formatted);
                        writer.flush();
                    }
                }
                catch (SocketException e) {
                    this.addInfo(this.host + ":" + this.port + " connection failed: " + e);
                }
                catch (IOException e) {
                    CloseUtil.closeQuietly((Socket)this.socket);
                    this.socket = null;
                    this.addInfo(this.host + ":" + this.port + " connection closed");
                }
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.addInfo("shutting down");
        ExecutorService service = this.getContext().getExecutorService();
        if (service instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)service).setCorePoolSize(0);
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        boolean errorPresent = false;
        if (this.port <= 0) {
            errorPresent = true;
            this.addError("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port");
        }
        if (this.host == null) {
            errorPresent = true;
            this.addError("No remote host was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host");
        }
        if (this.queueSize < 0) {
            errorPresent = true;
            this.addError("Queue size must be non-negative");
        }
        if (this.layout == null) {
            this.addError("No layout set for the appender named [" + this.name + "].");
            errorPresent = true;
        }
        if (!errorPresent) {
            try {
                this.address = InetAddress.getByName(this.host);
            }
            catch (UnknownHostException ex) {
                this.addError("unknown host: " + this.host);
                errorPresent = true;
            }
        }
        try {
            this.address = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException e) {
            this.addError("Unknown host: " + this.host);
            errorPresent = true;
        }
        if (!errorPresent) {
            this.queue = (BlockingQueue)((Object)(this.queueSize <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(this.queueSize)));
            this.task = this.getContext().getExecutorService().submit(this);
        }
        super.start();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        CloseUtil.closeQuietly((Socket)this.socket);
        this.task.cancel(true);
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        super.stop();
    }

    protected void append(ILoggingEvent event) {
        event.prepareForDeferredProcessing();
        event.getCallerData();
        if (event != null && this.started) {
            this.queue.offer(event);
        }
    }

    public void setRemoteHost(String host) {
        this.host = host;
    }

    public String getRemoteHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }
}

