/*
 * Decompiled with CFR 0.152.
 */
package com.tokenautocomplete;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.tokenautocomplete.Range;
import com.tokenautocomplete.Tokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TagTokenizer
implements Tokenizer {
    private ArrayList<Character> tagPrefixes;
    public static final Parcelable.Creator<TagTokenizer> CREATOR = new Parcelable.Creator<TagTokenizer>(){

        public TagTokenizer createFromParcel(Parcel in) {
            return new TagTokenizer(in);
        }

        public TagTokenizer[] newArray(int size) {
            return new TagTokenizer[size];
        }
    };

    TagTokenizer() {
        this(Arrays.asList(Character.valueOf('@'), Character.valueOf('#')));
    }

    public TagTokenizer(List<Character> tagPrefixes) {
        this.tagPrefixes = new ArrayList<Character>(tagPrefixes);
    }

    protected boolean isTokenTerminator(char character) {
        return !Character.isLetterOrDigit(character) && character != '_';
    }

    @Override
    public boolean containsTokenTerminator(CharSequence charSequence) {
        for (int i = 0; i < charSequence.length(); ++i) {
            if (!this.isTokenTerminator(charSequence.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    public List<Range> findTokenRanges(CharSequence charSequence, int start, int end) {
        ArrayList<Range> result = new ArrayList<Range>();
        if (start == end) {
            return result;
        }
        int tokenStart = Integer.MAX_VALUE;
        for (int cursor = start; cursor < end; ++cursor) {
            char character = charSequence.charAt(cursor);
            if (this.isTokenTerminator(character)) {
                if (cursor - 1 > tokenStart) {
                    result.add(new Range(tokenStart, cursor));
                }
                tokenStart = Integer.MAX_VALUE;
            }
            if (!this.tagPrefixes.contains(Character.valueOf(character))) continue;
            tokenStart = cursor;
        }
        if (end > tokenStart) {
            result.add(new Range(tokenStart, end));
        }
        return result;
    }

    @Override
    @NonNull
    public CharSequence wrapTokenValue(CharSequence text) {
        return text;
    }

    public int describeContents() {
        return 0;
    }

    TagTokenizer(Parcel in) {
        this(in.readArrayList(Character.class.getClassLoader()));
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeList(this.tagPrefixes);
    }
}

