/*
 * Decompiled with CFR 0.152.
 */
package com.tokenautocomplete;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.style.ReplacementSpan;
import android.view.View;
import android.view.ViewGroup;

public class ViewSpan
extends ReplacementSpan {
    protected View view;
    private Layout layout;
    private int cachedMaxWidth = -1;

    public ViewSpan(View view, Layout layout) {
        this.layout = layout;
        this.view = view;
        this.view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
    }

    private void prepView() {
        if (this.layout.getMaxViewSpanWidth() != this.cachedMaxWidth) {
            this.cachedMaxWidth = this.layout.getMaxViewSpanWidth();
            int spec = Integer.MIN_VALUE;
            if (this.cachedMaxWidth == 0) {
                spec = 0;
            }
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)this.cachedMaxWidth, (int)spec);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            this.view.measure(widthSpec, heightSpec);
            this.view.layout(0, 0, this.view.getMeasuredWidth(), this.view.getMeasuredHeight());
        }
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        this.prepView();
        canvas.save();
        canvas.translate(x, (float)top);
        this.view.draw(canvas);
        canvas.restore();
    }

    public int getSize(@NonNull Paint paint, CharSequence charSequence, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fontMetricsInt) {
        this.prepView();
        if (fontMetricsInt != null) {
            int height = this.view.getMeasuredHeight();
            int adjustedBaseline = this.view.getBaseline();
            if (adjustedBaseline == -1) {
                adjustedBaseline = height;
            }
            fontMetricsInt.ascent = fontMetricsInt.top = -adjustedBaseline;
            fontMetricsInt.descent = fontMetricsInt.bottom = height - adjustedBaseline;
        }
        return this.view.getRight();
    }

    public static interface Layout {
        public int getMaxViewSpanWidth();
    }
}

