/*
 * Decompiled with CFR 0.152.
 */
package com.tokenautocomplete;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import com.tokenautocomplete.CountSpan;
import com.tokenautocomplete.TokenCompleteTextView;

public class SpanUtils {
    @Nullable
    public static Spanned ellipsizeWithSpans(@Nullable CharSequence prefix, @Nullable CountSpan countSpan, int tokenCount, @NonNull TextPaint paint, @NonNull CharSequence originalText, float maxWidth) {
        float countWidth = 0.0f;
        if (countSpan != null) {
            countSpan.setCount(tokenCount);
            countWidth = countSpan.getCountTextWidthForPaint(paint);
        }
        EllipsizeCallback ellipsizeCallback = new EllipsizeCallback();
        CharSequence tempEllipsized = TextUtils.ellipsize((CharSequence)originalText, (TextPaint)paint, (float)(maxWidth - countWidth), (TextUtils.TruncateAt)TextUtils.TruncateAt.END, (boolean)false, (TextUtils.EllipsizeCallback)ellipsizeCallback);
        SpannableStringBuilder ellipsized = new SpannableStringBuilder(tempEllipsized);
        if (tempEllipsized instanceof Spanned) {
            TextUtils.copySpansFrom((Spanned)((Spanned)tempEllipsized), (int)0, (int)tempEllipsized.length(), Object.class, (Spannable)ellipsized, (int)0);
        }
        if (prefix != null && prefix.length() > ellipsizeCallback.start) {
            ellipsized.replace(0, ellipsizeCallback.start, prefix);
            ellipsizeCallback.end = ellipsizeCallback.end + prefix.length() - ellipsizeCallback.start;
            ellipsizeCallback.start = prefix.length();
        }
        if (ellipsizeCallback.start != ellipsizeCallback.end) {
            if (countSpan != null) {
                int visibleCount = ((TokenCompleteTextView.TokenImageSpan[])ellipsized.getSpans(0, ellipsized.length(), TokenCompleteTextView.TokenImageSpan.class)).length;
                countSpan.setCount(tokenCount - visibleCount);
                ellipsized.replace(ellipsizeCallback.start, ellipsized.length(), (CharSequence)countSpan.getCountText());
                ellipsized.setSpan((Object)countSpan, ellipsizeCallback.start, ellipsized.length(), 33);
            }
            return ellipsized;
        }
        return null;
    }

    private static class EllipsizeCallback
    implements TextUtils.EllipsizeCallback {
        int start = 0;
        int end = 0;

        private EllipsizeCallback() {
        }

        public void ellipsized(int ellipsedStart, int ellipsedEnd) {
            this.start = ellipsedStart;
            this.end = ellipsedEnd;
        }
    }
}

