/*
 * Copyright 2021 Splendo Consulting B.V. The Netherlands
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 */

package com.splendo.kaluga.resources

/**
 * All HTML supported colors https://htmlcolorcodes.com/color-names/
 */
object DefaultColors {
    val aliceBlue = colorFrom(240, 248, 255)
    val antiqueWhite = colorFrom(250, 235, 215)
    val aqua = colorFrom(0, 255, 255)
    val aquamarine = colorFrom(127, 255, 212)
    val azure = colorFrom(240, 255, 255)
    val beige = colorFrom(245, 245, 220)
    val bisque = colorFrom(255, 228, 196)
    val black = colorFrom(0, 0, 0)
    val blanchedAlmond = colorFrom(255, 235, 205)
    val blue = colorFrom(0, 0, 255)
    val blueViolet = colorFrom(138, 43, 226)
    val brown = colorFrom(165, 42, 42)
    val burlyWood = colorFrom(222, 184, 135)
    val cadetBlue = colorFrom(95, 158, 160)
    val chartreuse = colorFrom(127, 255, 0)
    val chocolate = colorFrom(210, 105, 30)
    val clear = colorFrom(0.0, 0.0, 0.0, 0.0)
    val coral = colorFrom(255, 127, 80)
    val cornflowerBlue = colorFrom(100, 149, 237)
    val cornsilk = colorFrom(255, 248, 220)
    val crimson = colorFrom(220, 20, 60)
    val cyan = colorFrom(0, 255, 255)
    val darkBlue = colorFrom(0, 0, 139)
    val darkCyan = colorFrom(0, 139, 139)
    val darkGoldenrod = colorFrom(184, 134, 11)
    val darkGray = colorFrom(169, 169, 169)
    val darkGreen = colorFrom(0, 100, 0)
    val darkKhaki = colorFrom(189, 183, 107)
    val darkMagenta = colorFrom(139, 0, 139)
    val darkOliveGreen = colorFrom(85, 107, 47)
    val darkOrange = colorFrom(255, 140, 0)
    val darkOrchid = colorFrom(153, 50, 204)
    val darkRed = colorFrom(139, 0, 0)
    val darkSalmon = colorFrom(233, 150, 122)
    val darkSeaGreen = colorFrom(143, 188, 139)
    val darkSlateBlue = colorFrom(72, 61, 139)
    val darkSlateGray = colorFrom(47, 79, 79)
    val darkTurquoise = colorFrom(0, 206, 209)
    val darkViolet = colorFrom(148, 0, 211)
    val deepPink = colorFrom(255, 20, 147)
    val deepSkyBlue = colorFrom(0, 191, 255)
    val dimGray = colorFrom(105, 105, 105)
    val dodgerBlue = colorFrom(30, 144, 255)
    val fireBrick = colorFrom(178, 34, 34)
    val floralWhite = colorFrom(255, 250, 240)
    val forestGreen = colorFrom(34, 139, 34)
    val fuchsia = colorFrom(255, 0, 255)
    val gainsboro = colorFrom(220, 220, 220)
    val ghostWhite = colorFrom(248, 248, 255)
    val gold = colorFrom(255, 215, 0)
    val goldenrod = colorFrom(218, 165, 32)
    val gray = colorFrom(128, 128, 128)
    val green = colorFrom(0, 128, 0)
    val greenYellow = colorFrom(173, 255, 47)
    val honeyDew = colorFrom(240, 255, 240)
    val hotPink = colorFrom(255, 105, 180)
    val indianRed = colorFrom(205, 92, 92)
    val indigo = colorFrom(75, 0, 130)
    val ivory = colorFrom(255, 255, 240)
    val khaki = colorFrom(240, 230, 140)
    val lavender = colorFrom(230, 230, 250)
    val lavenderBlush = colorFrom(255, 240, 245)
    val lawnGreen = colorFrom(124, 252, 0)
    val lemonChiffon = colorFrom(255, 250, 205)
    val lightBlue = colorFrom(173, 216, 230)
    val lightCoral = colorFrom(240, 128, 128)
    val lightCyan = colorFrom(224, 255, 255)
    val lightGoldenrodYellow = colorFrom(250, 250, 210)
    val lightGray = colorFrom(211, 211, 211)
    val lightGreen = colorFrom(144, 238, 144)
    val lightPink = colorFrom(255, 182, 193)
    val lightSalmon = colorFrom(255, 160, 122)
    val lightSeaGreen = colorFrom(32, 178, 170)
    val lightSkyBlue = colorFrom(135, 206, 250)
    val lightSlateGray = colorFrom(119, 136, 153)
    val lightSteelBlue = colorFrom(176, 196, 222)
    val lightYellow = colorFrom(255, 255, 224)
    val lime = colorFrom(0, 255, 0)
    val limeGreen = colorFrom(50, 205, 50)
    val linen = colorFrom(250, 240, 230)
    val magenta = colorFrom(255, 0, 255)
    val maroon = colorFrom(128, 0, 0)
    val mediumAquamarine = colorFrom(102, 205, 170)
    val mediumBlue = colorFrom(0, 0, 205)
    val mediumOrchid = colorFrom(186, 85, 211)
    val mediumPurple = colorFrom(147, 112, 219)
    val mediumSeaGreen = colorFrom(60, 179, 113)
    val mediumSlateBlue = colorFrom(123, 104, 238)
    val mediumSpringGreen = colorFrom(0, 250, 154)
    val mediumTurquoise = colorFrom(72, 209, 204)
    val mediumVioletRed = colorFrom(199, 21, 133)
    val midnightBlue = colorFrom(25, 25, 112)
    val mintCream = colorFrom(245, 255, 250)
    val mistyRose = colorFrom(255, 228, 225)
    val moccasin = colorFrom(255, 228, 181)
    val navajoWhite = colorFrom(255, 222, 173)
    val navy = colorFrom(0, 0, 128)
    val oldLace = colorFrom(253, 245, 230)
    val olive = colorFrom(128, 128, 0)
    val oliveDrab = colorFrom(107, 142, 35)
    val orange = colorFrom(255, 165, 0)
    val orangeRed = colorFrom(255, 69, 0)
    val orchid = colorFrom(218, 112, 214)
    val paleGoldenrod = colorFrom(238, 232, 170)
    val paleGreen = colorFrom(152, 251, 152)
    val paleTurquoise = colorFrom(175, 238, 238)
    val paleVioletRed = colorFrom(219, 112, 147)
    val papayaWhip = colorFrom(255, 239, 213)
    val peachPuff = colorFrom(255, 218, 185)
    val peru = colorFrom(205, 133, 63)
    val pink = colorFrom(255, 192, 203)
    val plum = colorFrom(221, 160, 221)
    val powderBlue = colorFrom(176, 224, 230)
    val purple = colorFrom(128, 0, 128)
    val rebeccaPurple = colorFrom(102, 51, 153)
    val red = colorFrom(255, 0, 0)
    val rosyBrown = colorFrom(188, 143, 143)
    val royalBlue = colorFrom(65, 105, 225)
    val saddleBrown = colorFrom(139, 69, 19)
    val salmon = colorFrom(250, 128, 114)
    val sandyBrown = colorFrom(244, 164, 96)
    val seaGreen = colorFrom(46, 139, 87)
    val seaShell = colorFrom(255, 245, 238)
    val sienna = colorFrom(160, 82, 45)
    val silver = colorFrom(192, 192, 192)
    val skyBlue = colorFrom(135, 206, 235)
    val slateBlue = colorFrom(106, 90, 205)
    val slateGray = colorFrom(112, 128, 144)
    val snow = colorFrom(255, 250, 250)
    val springGreen = colorFrom(0, 255, 127)
    val steelBlue = colorFrom(70, 130, 180)
    val tan = colorFrom(210, 180, 140)
    val teal = colorFrom(0, 128, 128)
    val thistle = colorFrom(216, 191, 216)
    val tomato = colorFrom(255, 99, 71)
    val turquoise = colorFrom(64, 224, 208)
    val violet = colorFrom(238, 130, 238)
    val wheat = colorFrom(245, 222, 179)
    val white = colorFrom(255, 255, 255)
    val whiteSmoke = colorFrom(245, 245, 245)
    val yellow = colorFrom(255, 255, 0)
    val yellowGreen = colorFrom(154, 205, 50)
}
