/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.maven;

import com.speedment.Speedment;
import com.speedment.component.Component;
import com.speedment.config.Project;
import com.speedment.internal.core.code.MainGenerator;
import com.speedment.internal.core.config.utils.GroovyParser;
import com.speedment.maven.AbstractSpeedmentMojo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractSpeedmentMojo {
    @Parameter
    private Component[] components;
    @Parameter(defaultValue="src/main/groovy/speedment.groovy")
    private File groovyFile;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (this.groovyFile == null) {
            String err = "If you want to use speedment:generate, you must configure a .groovy file using the <groovyFile> tag.";
            this.getLog().error((CharSequence)"If you want to use speedment:generate, you must configure a .groovy file using the <groovyFile> tag.");
            throw new MojoExecutionException("If you want to use speedment:generate, you must configure a .groovy file using the <groovyFile> tag.");
        }
        if (!this.groovyFile.exists()) {
            String err = "The specified groovy-file '" + this.groovyFile.getAbsolutePath() + "' does not exist.";
            this.getLog().error((CharSequence)err);
            throw new MojoExecutionException(err);
        }
        if (!this.groovyFile.canRead()) {
            String err = "The specified groovy-file '" + this.groovyFile.getAbsolutePath() + "' is not readable.";
            this.getLog().error((CharSequence)err);
            throw new MojoExecutionException(err);
        }
        this.getLog().info((CharSequence)("Creating from groovy file: '" + this.groovyFile.getAbsolutePath() + "'."));
        try {
            Project p = GroovyParser.projectFromGroovy((Speedment)this.getSpeedment(), (Path)this.groovyFile.toPath());
            new MainGenerator(this.getSpeedment()).accept(p);
        }
        catch (IOException ex) {
            String err = "IOException thrown when parsing Groovy-file.";
            this.getLog().error((CharSequence)"IOException thrown when parsing Groovy-file.");
            throw new MojoExecutionException("IOException thrown when parsing Groovy-file.", (Exception)ex);
        }
    }

    @Override
    protected Component[] components() {
        return this.components;
    }

    @Override
    protected String launchMessage() {
        return "Starting Speedment";
    }
}

