/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToEnumNullable;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToStringNullable;
import java.util.Objects;
import java.util.function.Function;

public final class ToEnumNullableImpl<T, E extends Enum<E>>
implements ToEnumNullable<T, E> {
    private final Class<E> enumClass;
    private final Function<T, E> inner;

    public ToEnumNullableImpl(Class<E> enumClass, Function<T, E> inner) {
        this.enumClass = Objects.requireNonNull(enumClass);
        this.inner = Objects.requireNonNull(inner);
    }

    @Override
    public Class<E> enumClass() {
        return this.enumClass;
    }

    @Override
    public E apply(T t) {
        return (E)((Enum)this.inner.apply(t));
    }

    @Override
    public ToIntNullable<T> asOrdinal() {
        return object -> this.isNotNull(object) ? Integer.valueOf(((Enum)this.apply(object)).ordinal()) : null;
    }

    @Override
    public ToStringNullable<T> asName() {
        return object -> this.isNotNull(object) ? ((Enum)this.apply(object)).name() : null;
    }

    @Override
    public long hash(T object) {
        return object == null ? 0L : (long)object.hashCode();
    }

    @Override
    public int compare(T first, T second) {
        Object f = this.apply((Object)first);
        Object s = this.apply((Object)second);
        if (f == null && s == null) {
            return 0;
        }
        if (f == null) {
            return 1;
        }
        if (s == null) {
            return -1;
        }
        return Integer.compare(((Enum)f).ordinal(), ((Enum)s).ordinal());
    }
}

